/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class AnimationTimer
implements ActionListener {
    Timer timer;
    MeDiViewer md;
    int cinemodus;

    public AnimationTimer(MeDiViewer md) {
        this.md = md;
        this.cinemodus = 0;
        this.timer = new Timer(1000, this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.cinemodus > 0) {
            if (this.cinemodus == 1 || this.cinemodus == 3) {
                this.md.doCommand(16);
            } else if (this.cinemodus == 2) {
                this.md.doCommand(17);
            }
        }
    }

    public synchronized void startAnimation() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public synchronized void startAnimation(int modus) {
        this.setModus(modus);
        this.startAnimation();
    }

    public synchronized void stopAnimation() {
        this.cinemodus = 0;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public int getModus() {
        return this.cinemodus;
    }

    public void setModus(int modi) {
        this.cinemodus = modi;
    }

    public void setSpeed(int delay) {
        this.timer.setDelay(1000 / delay);
    }

    public boolean getStatus() {
        return this.timer.isRunning();
    }
}

