/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class ByteProcessor
extends ImageProcessor {
    private FileInfo fi;
    private int min = 0;
    private int max = 255;
    protected byte[] pixels;

    public ByteProcessor(int width, int height, byte[] pixels, ColorModel cm, FileInfo fi) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.fi = fi;
        this.pixels = pixels;
        this.cm = cm;
        if (fi.ModalityLut) {
            int i = 0;
            while (i < this.pixels.length) {
                int pval = this.pixels[i];
                if (pval <= fi.mDescriptor[1]) {
                    pval = 0;
                } else if (pval > fi.mDescriptor[0] + fi.mDescriptor[1]) {
                    pval = 127;
                } else if (pval - fi.mDescriptor[1] - 1 < fi.LutData.length) {
                    pval = (byte)fi.LutData[pval - fi.mDescriptor[1] - 1];
                }
                this.pixels[i] = pval;
                ++i;
            }
            this.findMinAndMax();
        } else {
            this.hu2pv();
        }
    }

    public int centerHU2PV(int center) {
        return center;
    }

    public void findMinAndMax() {
    }

    public Image createImage() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Image pixelUpdate() {
        return this.createImage();
    }

    public void hu2pv() {
        this.resetMinAndMax();
    }

    public void resetMinAndMax() {
        this.setMinAndMax(0.0, 255.0);
    }

    public void setPVWC(int cw, int cc) {
        this.setMinAndMax(cc, cw);
    }

    public void setMinAndMax(double min, double max) {
        this.min = (int)min;
        this.max = (int)max;
        if (min < 0.0) {
            min = 0.0;
        } else if (min > max) {
            min = max - 1.0;
        }
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel m = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            m.getReds(this.rLUT1);
            m.getGreens(this.gLUT1);
            m.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int i = 0;
        while (i < 256) {
            if ((double)i < min) {
                this.rLUT2[i] = this.rLUT1[0];
                this.gLUT2[i] = this.gLUT1[0];
                this.bLUT2[i] = this.bLUT1[0];
            } else if ((double)i > max) {
                this.rLUT2[i] = this.rLUT1[255];
                this.gLUT2[i] = this.gLUT1[255];
                this.bLUT2[i] = this.bLUT1[255];
            } else {
                int index = i - this.min;
                if ((index = (int)(256.0 * (double)index / (max - min))) < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                this.rLUT2[i] = this.rLUT1[index];
                this.gLUT2[i] = this.gLUT1[index];
                this.bLUT2[i] = this.bLUT1[index];
            }
            ++i;
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
    }
}

