/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;

public class ColorProcessor
extends ImageProcessor {
    protected int[] pixels;
    int[] mpixels;
    private int min = 0;
    private int max = 255;
    private FileInfo fi;
    private int currentWidth;
    private int currentCenter;
    private int defaultWidth;
    private int defaultCenter;

    public ColorProcessor(int width, int height, int[] pixels, FileInfo fi) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.createColorModel();
        fi.cm = this.cm;
    }

    public Image createImage() {
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
            this.mpixels = new int[this.pixels.length];
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Image pixelUpdate() {
        int[] lut = new int[256];
        int i = 0;
        while (i < 256) {
            int v = i - this.min;
            if ((v = (int)(256.0 * (double)v / (double)(this.max - this.min))) < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lut[i] = v;
            ++i;
        }
        this.applyTable(lut);
        this.source.newPixels(this.mpixels, this.cm, 0, this.width);
        return this.img;
    }

    public void setMinAndMax(double min, double max) {
        if (max > 255.0) {
            max = 255.0;
        }
        this.min = (int)min;
        this.max = (int)max;
    }

    public void setMinAndMax(int min, int max) {
        if (max > 255) {
            max = 255;
        }
        this.min = min;
        this.max = max;
    }

    public void applyTable(int[] lut) {
        int y = 0;
        while (y < this.height) {
            int i = y * this.width;
            int x = 0;
            while (x < this.width) {
                int c = this.pixels[i];
                int r = lut[(c & 0xFF0000) >> 16];
                int g = lut[(c & 0xFF00) >> 8];
                int b = lut[c & 0xFF];
                this.mpixels[i] = -16777216 + (r << 16) + (g << 8) + b;
                ++i;
                ++x;
            }
            ++y;
        }
    }

    private void calculateMinAndMax() {
        int theWidth = this.max - this.min;
        int theCenter = this.min + this.max / 2;
        if (theWidth < 1) {
            theWidth = 1;
        }
        this.min = theCenter - theWidth / 2;
        this.max = theCenter + theWidth / 2;
    }

    public void setPVWC(int cw, int cc) {
        this.min = cc;
        this.max = cw;
        this.calculateMinAndMax();
    }

    private void createColorModel() {
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public void hu2pv() {
        this.setMinAndMax(0, 255);
    }
}

