/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import sub.Tools;

class DicomDecoderX {
    private static final int SOP_INSTANCE_UID = 524312;
    private static final int MODALITY = 524384;
    private static final int INSTITUION = 524416;
    private static final int PATIENTS_NAME = 0x100010;
    private static final int PATIENTS_ID = 0x100020;
    private static final int BIRTH_DATE = 0x100030;
    private static final int PATIENTS_SEX = 0x100040;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int IMAGE_TIME = 524339;
    private static final int SLICE_THICKNESS = 1572944;
    private static final int KVP = 1572960;
    private static final int SLICE_SPACING = 0x180088;
    private static final int EXPOSURE_TIME = 1577296;
    private static final int XRAY_TUBE_CURRENT = 0x181151;
    private static final int IMAGE_AREA_DOSE_PRODUCT = 1577310;
    private static final int XRAY_EXPOSURE = 1577989;
    private static final int ROTATE_STATE = 1638434;
    private static final int FLIP_STATE = 1638435;
    private static final int SERIES_NUMBER = 0x200011;
    private static final int IMAGE_NUMBER = 2097171;
    private static final int IMAGE_ORIENTATION = 2097207;
    private static final int IMAGE_COMMENT = 0x204000;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int BITS_STORED = 2621697;
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int LOSSY_COMPRESSION = 2629904;
    private static final int LUT_DESCRIPTOR = 2633730;
    private static final int LUT_DATA = 2633734;
    private static final int PIXEL_DATA = 2145386512;
    private static final int ITEM = -73728;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private String HeaderString = "";
    private int counter = 0;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private boolean dicmFound;
    private boolean oddLocations;
    private boolean bigEndianTransferSyntax = false;
    int windowCenter;
    int windowWidth;
    static char[] buf8;
    char[] buf10;

    static {
        buf8 = new char[8];
    }

    public DicomDecoderX(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        if (dictionary == null) {
            DicomDictionary d = new DicomDictionary();
            dictionary = d.getDictionary();
        }
    }

    String getString(int length) throws IOException {
        byte[] buf = new byte[length];
        int pos = 0;
        while (pos < length) {
            int count = this.f.read(buf, pos, length - pos);
            pos += count;
        }
        this.location += length;
        return new String(buf).trim();
    }

    int getByte() throws IOException {
        int b = this.f.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return b;
    }

    int getShort() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        if (this.littleEndian) {
            return (b1 << 8) + b0;
        }
        return (b0 << 8) + b1;
    }

    final int getInt() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    byte[] getLut(int length) throws IOException {
        if ((length & 1) != 0) {
            return null;
        }
        byte[] lut = new byte[length /= 2];
        int i = 0;
        while (i < length) {
            lut[i] = (byte)(this.getShort() >>> 8);
            ++i;
        }
        return lut;
    }

    int getLength() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        this.vr = (b0 << 8) + b1;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b2 == 0 || b3 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
                }
                return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.littleEndian) {
                    return (b3 << 8) + b2;
                }
                return (b2 << 8) + b3;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    int getNextTag() throws IOException {
        int groupWord = this.getShort();
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            this.littleEndian = false;
            groupWord = 8;
        }
        int elementWord = this.getShort();
        int tag = groupWord << 16 | elementWord;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        return tag;
    }

    FileInfo getFileInfo() throws IOException {
        URL u;
        boolean isURL = this.directory.indexOf("://") > 0;
        FileInfo fi = new FileInfo();
        int bitsAllocated = 16;
        fi.fileName = this.fileName;
        if (isURL) {
            fi.url = this.directory;
        } else {
            fi.directory = this.directory;
        }
        fi.width = 0;
        fi.height = 0;
        fi.offset = 0;
        fi.intelByteOrder = true;
        fi.fileType = 2;
        fi.fileFormat = 6;
        int samplesPerPixel = 1;
        int planarConfiguration = 0;
        String photoInterpretation = "";
        if (isURL) {
            u = new URL(String.valueOf(fi.url) + fi.fileName);
            this.f = new BufferedInputStream(u.openStream());
        } else {
            this.f = new BufferedInputStream(new FileInputStream(String.valueOf(this.directory) + this.fileName));
        }
        long skipCount = 128L;
        while (skipCount > 0L) {
            skipCount -= this.f.skip(skipCount);
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            this.f.close();
            if (isURL) {
                u = new URL(String.valueOf(fi.url) + fi.fileName);
                this.f = new BufferedInputStream(u.openStream());
            } else {
                this.f = new BufferedInputStream(new FileInputStream(String.valueOf(this.directory) + this.fileName));
            }
            this.location = 0;
        } else {
            this.dicmFound = true;
        }
        boolean decodingTags = true;
        boolean signed = false;
        block49: while (decodingTags) {
            int tag = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
            }
            switch (tag) {
                case 0x100030: {
                    fi.patBirth = this.getString(this.elementLength);
                    this.addInfo(tag, fi.patBirth);
                    break;
                }
                case 2621696: {
                    bitsAllocated = this.getShort();
                    if (bitsAllocated == 8) {
                        fi.fileType = 0;
                    } else if (bitsAllocated == 32) {
                        fi.fileType = 11;
                    }
                    this.addInfo(tag, bitsAllocated);
                    break;
                }
                case 2621697: {
                    fi.bitsStored = this.getShort();
                    this.addInfo(tag, fi.bitsStored);
                    break;
                }
                case 2621457: {
                    fi.width = this.getShort();
                    this.addInfo(tag, fi.width);
                    break;
                }
                case 1577296: {
                    fi.ExposureTime = this.getString(this.elementLength);
                    this.addInfo(tag, fi.ExposureTime);
                    break;
                }
                case 1638435: {
                    String fs = this.getString(this.elementLength);
                    fi.FlipState = this.s2i(fs);
                    this.addInfo(tag, fi.FlipState);
                    break;
                }
                case 1577310: {
                    fi.ImageDose = this.getString(this.elementLength);
                    this.addInfo(tag, fi.ImageDose);
                    break;
                }
                case 0x204000: {
                    fi.ImageComment = this.getString(this.elementLength);
                    this.addInfo(tag, fi.ImageComment);
                    break;
                }
                case 2097171: {
                    String imgnr = this.getString(this.elementLength);
                    fi.imageNr = this.s2i(imgnr);
                    this.addInfo(tag, fi.imageNr);
                    break;
                }
                case 2097207: {
                    fi.pOrientation = this.getString(this.elementLength);
                    this.addInfo(tag, fi.pOrientation);
                    break;
                }
                case 524339: {
                    fi.ImageTime = this.getString(this.elementLength);
                    this.addInfo(tag, fi.ImageTime);
                    break;
                }
                case 524416: {
                    fi.institution = this.getString(this.elementLength);
                    this.addInfo(tag, fi.institution);
                    break;
                }
                case 1572960: {
                    fi.KVP = this.getString(this.elementLength);
                    this.addInfo(tag, fi.KVP);
                    break;
                }
                case 2629904: {
                    String lc = this.getString(this.elementLength);
                    int x = 0;
                    try {
                        x = Integer.parseInt(lc);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (x != 0) {
                        fi.compression = true;
                    }
                    this.addInfo(tag, lc);
                    break;
                }
                case 2633730: {
                    String ld = "";
                    int n = this.elementLength / 2;
                    fi.mDescriptor = new int[n];
                    int i = 0;
                    while (i < n) {
                        fi.mDescriptor[i] = this.getShort();
                        ld = String.valueOf(ld) + " " + fi.mDescriptor[i];
                        ++i;
                    }
                    this.addInfo(tag, ld);
                    break;
                }
                case 2633734: {
                    String ldata = "";
                    int j = this.elementLength / 2;
                    fi.LutData = new int[j];
                    int i = 0;
                    while (i < j) {
                        fi.LutData[i] = this.getShort();
                        ldata = String.valueOf(ldata) + " " + fi.LutData[i];
                        ++i;
                    }
                    fi.ModalityLut = true;
                    this.addInfo(tag, ldata);
                    break;
                }
                case 524384: {
                    fi.modality = this.getString(this.elementLength);
                    this.addInfo(tag, fi.modality);
                    break;
                }
                case 0x280008: {
                    String s = this.getString(this.elementLength);
                    this.addInfo(tag, s);
                    double frames = this.s2d(s);
                    if (!(frames > 1.0)) continue block49;
                    fi.nImages = (int)frames;
                    break;
                }
                case 0x100010: {
                    fi.patName = this.getString(this.elementLength);
                    fi.patName = fi.patName.replace('^', ' ');
                    fi.patName.trim();
                    this.addInfo(tag, fi.patName);
                    break;
                }
                case 0x100040: {
                    fi.patSex = this.getString(this.elementLength);
                    this.addInfo(tag, fi.patSex);
                    break;
                }
                case 0x100020: {
                    fi.patID = this.getString(this.elementLength);
                    this.addInfo(tag, fi.patID);
                    break;
                }
                case 2621699: {
                    int pixelRepresentation = this.getShort();
                    if (pixelRepresentation == 1) {
                        fi.fileType = 1;
                        signed = true;
                    }
                    this.addInfo(tag, pixelRepresentation);
                    break;
                }
                case 2621488: {
                    String scale = this.getString(this.elementLength);
                    this.getSpatialScale(fi, scale);
                    this.addInfo(tag, scale);
                    break;
                }
                case 2621444: {
                    photoInterpretation = this.getString(this.elementLength);
                    this.addInfo(tag, photoInterpretation);
                    break;
                }
                case 2621446: {
                    planarConfiguration = this.getShort();
                    this.addInfo(tag, planarConfiguration);
                    break;
                }
                case 2625618: {
                    int intercept;
                    String interp = this.getString(this.elementLength);
                    fi.intercept = intercept = this.s2sci(interp);
                    this.addInfo(tag, intercept);
                    break;
                }
                case 2625619: {
                    String Slope = this.getString(this.elementLength);
                    int slope = this.s2sci(Slope);
                    if (slope == 0) {
                        slope = 1;
                    }
                    fi.slope = slope;
                    this.addInfo(tag, slope);
                    break;
                }
                case 1638434: {
                    String rs = this.getString(this.elementLength);
                    fi.RotateState = this.s2i(rs);
                    this.addInfo(tag, fi.RotateState);
                    break;
                }
                case 2621456: {
                    fi.height = this.getShort();
                    this.addInfo(tag, fi.height);
                    break;
                }
                case 0x280002: {
                    samplesPerPixel = this.getShort();
                    this.addInfo(tag, samplesPerPixel);
                    break;
                }
                case 0x200011: {
                    fi.SeriesNumber = this.getString(this.elementLength);
                    this.addInfo(tag, fi.SeriesNumber);
                    break;
                }
                case 0x180088: {
                    String spacing = this.getString(this.elementLength);
                    fi.pixelDepth = this.s2d(spacing);
                    this.addInfo(tag, spacing);
                    break;
                }
                case 1572944: {
                    fi.SliceThickness = this.getString(this.elementLength);
                    this.addInfo(tag, fi.SliceThickness);
                    break;
                }
                case 524312: {
                    fi.InstanceUID = this.getString(this.elementLength);
                    this.addInfo(tag, fi.InstanceUID);
                    break;
                }
                case 131088: {
                    String s = this.getString(this.elementLength);
                    this.addInfo(tag, s);
                    if (s.indexOf("1.2.4") > -1 || s.indexOf("1.2.5") > -1) {
                        this.f.close();
                        throw new IOException("Cannot open compressed DICOM images.\n \nTransfer Syntax UID = " + s);
                    }
                    if (s.indexOf("1.2.840.10008.1.2.2") < 0) continue block49;
                    this.bigEndianTransferSyntax = true;
                    break;
                }
                case 2625616: {
                    int windowCenter;
                    String center = this.getString(this.elementLength);
                    fi.windowCenter = windowCenter = this.s2i(center);
                    this.addInfo(tag, center);
                    break;
                }
                case 2625617: {
                    int windowWidth;
                    String width = this.getString(this.elementLength);
                    fi.windowWidth = windowWidth = this.s2i(width);
                    this.addInfo(tag, width);
                    break;
                }
                case 0x181151: {
                    fi.XRayTubeCurrent = this.getString(this.elementLength);
                    this.addInfo(tag, fi.XRayTubeCurrent);
                    break;
                }
                case 1577989: {
                    fi.XRayExposure = this.getString(this.elementLength);
                    this.addInfo(tag, fi.XRayExposure);
                    break;
                }
                case 2626049: {
                    fi.reds = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    break;
                }
                case 2626050: {
                    fi.greens = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    break;
                }
                case 2626051: {
                    fi.blues = this.getLut(this.elementLength);
                    this.addInfo(tag, this.elementLength / 2);
                    break;
                }
                case 2145386512: {
                    if (this.elementLength != 0) {
                        fi.offset = this.location;
                        this.addInfo(tag, this.location);
                        decodingTags = false;
                        break;
                    }
                    this.addInfo(tag, null);
                    break;
                }
                case 2139619344: {
                    if (this.elementLength == 0) continue block49;
                    fi.offset = this.location + 4;
                    decodingTags = false;
                    break;
                }
                default: {
                    if (this.elementLength > 250) {
                        this.addInfo(tag, null);
                        break;
                    }
                    String def = this.getString(this.elementLength);
                    this.addInfo(tag, def);
                }
            }
        }
        if (fi.fileType == 0 && fi.reds != null && fi.greens != null && fi.blues != null && fi.reds.length == fi.greens.length && fi.reds.length == fi.blues.length) {
            fi.fileType = 5;
            fi.lutSize = fi.reds.length;
        }
        if (fi.fileType == 11 && signed) {
            fi.fileType = 3;
        }
        if (samplesPerPixel == 3 && photoInterpretation.startsWith("RGB")) {
            if (planarConfiguration == 0) {
                fi.fileType = 6;
            } else if (planarConfiguration == 1) {
                fi.fileType = 7;
            }
        }
        if (photoInterpretation.endsWith("1")) {
            fi.whiteIsZero = true;
        }
        if (!this.littleEndian) {
            fi.intelByteOrder = false;
        }
        this.f.close();
        return fi;
    }

    String getHeaderDaten() {
        return this.HeaderString;
    }

    void addInfo(int tag, String value) throws IOException {
        String info = this.getHeaderInfo(tag, value);
        if (info != null && tag != -73728) {
            int group;
            this.previousGroup = group = tag >>> 16;
        }
        if (value == null) {
            value = "-";
        } else if ((value = value.trim()).length() == 0) {
            value = "-";
        }
        if (value != null) {
            this.HeaderString = String.valueOf(this.HeaderString) + this.tag2hex(tag).trim() + " ";
            String desc = (String)((Hashtable)dictionary).get(this.i2hex(tag));
            desc = desc == null ? "??Unknown*Element" : desc.replace(' ', '*');
            String type = desc.substring(0, 2);
            this.HeaderString = String.valueOf(this.HeaderString) + type + " ";
            desc = desc.substring(2, desc.length());
            this.HeaderString = String.valueOf(this.HeaderString) + desc + " ";
            value = value.replace(' ', '*');
            this.HeaderString = String.valueOf(this.HeaderString) + value + " ";
            ++this.counter;
        }
    }

    void addInfo(int tag, int value) throws IOException {
        this.addInfo(tag, Integer.toString(value));
    }

    String getHeaderInfo(int tag, String value) throws IOException {
        String key = this.i2hex(tag);
        String id = (String)((Hashtable)dictionary).get(key);
        if (id != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            id = id.substring(2);
        }
        if (tag == -73728) {
            return id != null ? String.valueOf(id) + ":" : null;
        }
        if (value != null) {
            return String.valueOf(id) + ": " + value;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.getShort());
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                int i = 0;
                while (i < n) {
                    value = String.valueOf(value) + Integer.toString(this.getShort()) + " ";
                    ++i;
                }
                break;
            }
            case 21329: {
                value = "";
                break;
            }
            default: {
                long skipCount = this.elementLength;
                while (skipCount > 0L) {
                    skipCount -= this.f.skip(skipCount);
                }
                this.location += this.elementLength;
                value = "";
            }
        }
        if (value != null && id == null && !value.equals("")) {
            return "---: " + value;
        }
        if (id == null) {
            return null;
        }
        return String.valueOf(id) + ": " + value;
    }

    String i2hex(int i) {
        int pos = 7;
        while (pos >= 0) {
            DicomDecoderX.buf8[pos] = Tools.hexDigits[i & 0xF];
            i >>>= 4;
            --pos;
        }
        return new String(buf8);
    }

    String tag2hex(int tag) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int pos = 8;
        while (pos >= 0) {
            this.buf10[pos] = Tools.hexDigits[tag & 0xF];
            tag >>>= 4;
            if (--pos != 4) continue;
            --pos;
        }
        return new String(this.buf10);
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    int s2i(String s) {
        Integer i;
        try {
            s = s.toUpperCase();
            int ind = s.indexOf(69);
            if (ind > 0) {
                String op = s.substring(ind + 1, ind + 2);
                String value = s.substring(0, ind);
                String fak = s.substring(ind + 2);
                return this.getExp(value, fak, op);
            }
            ind = s.indexOf(92);
            if (ind > 0) {
                s = s.substring(0, ind);
            }
            if ((ind = s.indexOf(46)) > 0) {
                s = s.substring(0, ind);
            }
            i = new Integer(s);
        }
        catch (NumberFormatException e) {
            i = null;
        }
        if (i != null) {
            return i;
        }
        return 0;
    }

    int s2sci(String s) {
        Integer i = null;
        try {
            int ind = s.indexOf(69);
            int ind2 = s.indexOf(101);
            if (ind > 0) {
                String op = s.substring(ind + 1, ind + 2);
                String value = s.substring(0, ind);
                String fak = s.substring(ind + 2);
                return this.getExp(value, fak, op);
            }
            if (ind2 > 0) {
                String op = s.substring(ind + 1, ind + 2);
                String value = s.substring(0, ind2);
                String fak = s.substring(ind2 + 2);
                return this.getExp(value, fak, op);
            }
            ind = s.indexOf(46);
            if (ind > 0) {
                s = s.substring(0, ind);
                i = new Integer(s);
            } else {
                i = new Integer(s);
            }
        }
        catch (NumberFormatException e) {
            i = null;
        }
        if (i != null) {
            return i;
        }
        return 0;
    }

    int getExp(String value, String fak, String op) {
        double v = Double.parseDouble(value);
        double f = Double.parseDouble(fak);
        if (op.compareTo("+") == 0) {
            return (int)(v * Math.pow(10.0, f));
        }
        int i = 0;
        while ((double)i < f) {
            v /= 10.0;
            ++i;
        }
        return (int)v;
    }

    void getSpatialScale(FileInfo fi, String scale) {
        double xscale = 0.0;
        double yscale = 0.0;
        int i = scale.indexOf(92);
        if (i > 0) {
            xscale = this.s2d(scale.substring(0, i));
            yscale = this.s2d(scale.substring(i + 1));
        } else {
            xscale = this.s2d(scale);
        }
        if (xscale != 0.0 && yscale != 0.0) {
            fi.pixelWidth = xscale;
            fi.pixelHeight = yscale;
            fi.unit = "mm";
        } else if (xscale != 0.0 && yscale == 0.0) {
            yscale = xscale;
            fi.pixelWidth = xscale;
            fi.pixelHeight = yscale;
            fi.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }
}

