/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.util.StringTokenizer;

public class DicomImage {
    private FileInfo fi;
    private int id;
    private ImageProcessor ip;
    private Object pixels;
    private int type;
    private int width;
    private int height;
    int windowWidth;
    int windowCenter;
    float[] iPos;
    private boolean isByte = false;
    private int FlipState;
    private int RotateState;

    public DicomImage(FileInfo fi, int id) {
        this.fi = fi;
        this.id = id;
        this.width = fi.width;
        this.height = fi.height;
        this.iPos = new float[6];
        this.FlipState = fi.FlipState;
        this.RotateState = fi.RotateState;
        if (fi.modality == null) {
            fi.modality = "NA";
        }
        if ((fi.modality.equalsIgnoreCase("CT") || fi.modality.equalsIgnoreCase("MR")) && fi.pOrientation != null) {
            StringTokenizer st = new StringTokenizer(fi.pOrientation, "\\|");
            int i = 0;
            while (st.hasMoreTokens()) {
                this.iPos[i] = Float.parseFloat(st.nextToken());
                ++i;
            }
        }
        if (id == 0 && fi.windowCenter == 0 && fi.windowWidth == 0) {
            this.getImage();
            if (this.ip instanceof ColorProcessor || this.ip instanceof ByteProcessor) {
                fi.windowWidth = 255;
                fi.slope = 0;
                fi.intercept = 0;
                fi.windowCenter = 0;
            } else {
                fi.windowWidth = (int)this.ip.getMax() * 2;
                fi.windowCenter = fi.windowWidth / 2;
            }
            this.windowCenter = fi.windowCenter;
        } else if (id == 0 && fi.ModalityLut) {
            this.getImage();
        }
        if (fi.windowWidth == 0 && fi.modality.equalsIgnoreCase("CR")) {
            fi.windowWidth = MeDiViewer.WIDTH_CR;
            fi.windowCenter = MeDiViewer.LEVEL_CR;
        } else if (fi.windowWidth == 0 && fi.modality.equalsIgnoreCase("CT")) {
            fi.windowWidth = MeDiViewer.WIDTH_CT;
            fi.windowCenter = MeDiViewer.LEVEL_CT;
        } else if (fi.windowWidth == 0 && fi.modality.equalsIgnoreCase("MR")) {
            fi.windowWidth = MeDiViewer.WIDTH_MR;
            fi.windowCenter = MeDiViewer.LEVEL_MR;
        } else if (fi.windowWidth == 0 && fi.modality.equalsIgnoreCase("US")) {
            fi.windowWidth = 255;
            fi.windowCenter = 0;
        } else if (fi.windowWidth == 0 && fi.windowCenter == 0) {
            this.windowWidth = 0;
            this.windowCenter = 0;
        }
        this.windowWidth = fi.windowWidth;
        this.windowCenter = fi.slope != 0 ? fi.windowCenter / fi.slope : fi.windowCenter;
        if (fi.imageNr == 99999) {
            fi.windowWidth = 255;
            this.windowWidth = 255;
            fi.windowCenter = 0;
            this.windowCenter = 0;
        }
    }

    private void createProcessor() {
        switch (this.fi.fileType) {
            case 0: {
                this.ip = new ByteProcessor(this.width, this.height, (byte[])this.pixels, this.fi.cm, this.fi);
                this.isByte = true;
                break;
            }
            case 1: 
            case 2: {
                this.ip = new ShortProcessor(this.width, this.height, (short[])this.pixels, this.fi.cm, this.fi);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                this.ip = new ColorProcessor(this.width, this.height, (int[])this.pixels, this.fi);
            }
        }
        if (this.ip instanceof ColorProcessor || this.ip instanceof ByteProcessor) {
            this.windowWidth = 255;
            this.windowCenter = 0;
            this.fi.windowWidth = 255;
            this.fi.windowCenter = 0;
        }
        if (this.fi.ModalityLut) {
            this.windowWidth = (int)this.ip.getMax();
            this.windowCenter = (int)this.ip.getMax() / 2;
        }
        if (this.windowWidth == 0 && this.windowCenter == 0) {
            this.windowWidth = (int)this.ip.getMax() * this.fi.slope;
            this.windowCenter = (int)this.ip.getMin() * this.fi.slope - this.fi.intercept;
        }
        this.fi.windowWidth = this.windowWidth;
        this.fi.windowCenter = this.windowCenter;
    }

    public void dispose() {
        this.ip = null;
        this.pixels = null;
    }

    public void doInvert() {
        if (this.ip != null && (this.ip instanceof ByteProcessor || this.ip instanceof ShortProcessor)) {
            this.ip.invertLut();
        }
    }

    public FileInfo getFileInfo() {
        return this.fi;
    }

    public String getHeaderInformation() {
        return this.fi.HeaderDaten;
    }

    public int getID() {
        return this.id;
    }

    public String getInstitution() {
        if (this.fi.institution == null) {
            return "Unknown";
        }
        if (this.fi.institution.length() == 0) {
            return "Unknown";
        }
        return this.fi.institution;
    }

    public int getFlipState() {
        return this.FlipState;
    }

    public double getImageAngle() {
        double angle = 0.0;
        if (this.RotateState == 3) {
            angle = 90.0;
        } else if (this.RotateState == 2) {
            angle = 180.0;
        } else if (this.RotateState == 1) {
            angle = 270.0;
        }
        return angle;
    }

    public void RotateClockwise() {
        this.RotateState = this.RotateState == 0 ? 3 : --this.RotateState;
    }

    public void RotateAntiClockwise() {
        this.RotateState = this.RotateState == 3 ? 0 : ++this.RotateState;
    }

    public Image getImage() {
        if (this.pixels == null) {
            this.loadImage();
        }
        this.InitProcessor();
        return this.ip.getImage();
    }

    public void InitProcessor() {
        if (this.ip == null && this.pixels != null) {
            this.createProcessor();
        }
    }

    public boolean is8Bit() {
        return this.isByte;
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public String getImageComment() {
        if (this.fi.ImageComment == null) {
            return "";
        }
        return this.fi.ImageComment;
    }

    public String getImageDose() {
        return this.fi.ImageDose;
    }

    public String getXRayExposure() {
        return this.fi.XRayExposure;
    }

    public int getIntercept() {
        return this.fi.intercept;
    }

    public double getMax() {
        return this.ip.getMax();
    }

    public double getMin() {
        return this.ip.getMin();
    }

    public String getLeftMarker() {
        if (this.iPos[0] == 1.0f) {
            return "R";
        }
        if (this.iPos[0] == -1.0f) {
            return "L";
        }
        return "";
    }

    public String getRightMarker() {
        if (this.iPos[0] == 1.0f) {
            return "L";
        }
        if (this.iPos[0] == -1.0f) {
            return "R";
        }
        return "";
    }

    public String getUpperMarker() {
        if (this.iPos[1] > 0.0f) {
            return "P";
        }
        if (this.iPos[1] < 0.0f) {
            return "A";
        }
        return "";
    }

    public String getBottomMarker() {
        if (this.iPos[1] > 0.0f) {
            return "A";
        }
        if (this.iPos[1] < 0.0f) {
            return "P";
        }
        return "";
    }

    public String getModality() {
        if (this.fi.modality == null) {
            return "Unknown";
        }
        if (this.fi.modality.length() == 0) {
            return "Unknown";
        }
        return this.fi.modality;
    }

    public String getPatBirth() {
        return this.fi.patBirth;
    }

    public String getPatID() {
        if (this.fi.patID == null) {
            return "Unknown";
        }
        if (this.fi.patID.length() == 0) {
            return "Unknown";
        }
        return this.fi.patID;
    }

    public String getPatName() {
        return this.fi.patName;
    }

    public String getKVP() {
        if (this.fi.KVP.equals("0")) {
            return "-";
        }
        return String.valueOf(this.fi.KVP) + "";
    }

    public String getMAS() {
        int mVal = 0;
        try {
            this.fi.ExposureTime = this.fi.ExposureTime.replace('+', ' ');
            this.fi.ExposureTime = this.fi.ExposureTime.replace('-', ' ');
            this.fi.ExposureTime = this.fi.ExposureTime.trim();
            this.fi.XRayTubeCurrent = this.fi.XRayTubeCurrent.replace('+', ' ');
            this.fi.XRayTubeCurrent = this.fi.XRayTubeCurrent.replace('-', ' ');
            this.fi.XRayTubeCurrent = this.fi.XRayTubeCurrent.trim();
            int ExpTime = Integer.parseInt(this.fi.ExposureTime);
            int TubCurrent = Integer.parseInt(this.fi.XRayTubeCurrent);
            mVal = ExpTime * TubCurrent / 1000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (mVal == 0) {
            return "-";
        }
        return String.valueOf(mVal) + "";
    }

    public int getBitDepth() {
        return this.fi.bitsStored;
    }

    public String getPatSex() {
        return this.fi.patSex;
    }

    public String getInstanceUID() {
        return this.fi.InstanceUID;
    }

    public String getImageTime() {
        return this.fi.ImageTime;
    }

    public String getSliceThickness() {
        return this.fi.SliceThickness;
    }

    public String getSeriesNumber() {
        return this.fi.SeriesNumber;
    }

    public double getPixelHeight() {
        return this.fi.pixelHeight;
    }

    public Object getPixels() {
        return this.pixels;
    }

    public double getPixelWidth() {
        return this.fi.pixelWidth;
    }

    public String getPixelUnit() {
        return this.fi.unit;
    }

    public int getSlope() {
        return this.fi.slope;
    }

    public int getWindowCenter() {
        return this.windowCenter;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getXRayNumber() {
        return this.fi.imageNr;
    }

    public boolean isCompressed() {
        return this.fi.compression;
    }

    public boolean isInverted() {
        if (this.ip != null) {
            return this.ip.invertedLut;
        }
        return false;
    }

    public void loadImage() {
        this.pixels = OpenDicom.readPixels(this.fi);
    }

    public void reset() {
        this.ip.hu2pv();
        this.ip.pixelUpdate();
    }

    public void setMinAndMax(double min, double max) {
        this.ip.setMinAndMax(min, max);
    }

    public void setPVWC(int ww, int wc) {
        if (this.ip == null) {
            this.getImage();
        }
        if (this.isByte && wc < 0) {
            wc = 0;
        }
        this.ip.setPVWC(ww, wc);
        this.ip.pixelUpdate();
    }

    public void setWindowCenter(int center) {
        this.windowCenter = center;
    }

    public void setWindowWidth(int width) {
        this.windowWidth = width;
    }

    public void update() {
        this.ip.pixelUpdate();
    }
}

