/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public class DisplayConfig {
    static boolean annotation;
    static int LoupeSize;
    static int MagnifyZoom;
    double angle = 0.0;
    int FlipState;
    Point ImagePosition;
    boolean invert;
    boolean center;
    double min;
    double max;
    int pvW;
    int pvC;
    double scale = 0.1;
    double SCALE_MAX = 8.0;
    double SCALE_MIN = 0.1;
    boolean updateWindow;
    int ww;
    int wc;
    String birth;
    String StudyDate;

    public DisplayConfig() {
        annotation = true;
        this.invert = false;
        this.center = true;
        this.ImagePosition = new Point(0, 0);
        this.updateWindow = false;
        LoupeSize = 100;
        MagnifyZoom = 2;
        this.StudyDate = "00.00.0000";
    }

    public void addScale(double val) {
        this.setScale(this.scale + val);
    }

    public void centerHU2PV(int slope, int intercept) {
        this.pvC = slope != 0 ? this.wc - intercept / slope : this.wc - intercept;
    }

    public void fitImage(int iw, int ih, int pw, int ph) {
        if (pw > ph) {
            this.setScale((double)ph / (double)Math.max(iw, ih));
        } else {
            this.setScale((double)pw / (double)Math.max(iw, ih));
        }
        this.centerImage(iw, ih, pw, ph);
    }

    public void centerImage(int iw, int ih, int pw, int ph) {
        int xpos = (int)((double)(pw / 2) - (double)iw * this.scale / 2.0);
        int ypos = (int)((double)(ph / 2) - (double)ih * this.scale / 2.0);
        this.ImagePosition.setLocation(xpos, ypos);
    }

    public void FlipHorizontal() {
        if (this.angle != 90.0 && this.angle != 270.0) {
            if (this.FlipState == 0) {
                this.FlipState = 1;
            } else if (this.FlipState == 3) {
                this.FlipState = 2;
            } else if (this.FlipState == 2) {
                this.FlipState = 3;
            } else if (this.FlipState == 1) {
                this.FlipState = 0;
            }
        } else if (this.FlipState == 0) {
            this.FlipState = 2;
        } else if (this.FlipState == 1) {
            this.FlipState = 3;
        } else if (this.FlipState == 2) {
            this.FlipState = 0;
        } else if (this.FlipState == 3) {
            this.FlipState = 1;
        }
    }

    public void FlipVertical() {
        if (this.angle != 90.0 && this.angle != 270.0) {
            if (this.FlipState == 0) {
                this.FlipState = 2;
            } else if (this.FlipState == 1) {
                this.FlipState = 3;
            } else if (this.FlipState == 2) {
                this.FlipState = 0;
            } else if (this.FlipState == 3) {
                this.FlipState = 1;
            }
        } else if (this.FlipState == 0) {
            this.FlipState = 1;
        } else if (this.FlipState == 3) {
            this.FlipState = 2;
        } else if (this.FlipState == 2) {
            this.FlipState = 3;
        } else if (this.FlipState == 1) {
            this.FlipState = 0;
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean getAnnotation() {
        return annotation;
    }

    public int getFlipState() {
        return this.FlipState;
    }

    public Point getImagePosition() {
        return this.ImagePosition;
    }

    public int getLoupeSize() {
        return LoupeSize;
    }

    public int getMagnifyZoom() {
        return MagnifyZoom;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public int getPVC() {
        return this.pvC;
    }

    public int getPVW() {
        return this.pvW;
    }

    public double getScale() {
        return this.scale;
    }

    public String getScalePercent() {
        return String.valueOf((int)(this.scale * 100.0)) + "%";
    }

    public String getStudyDate() {
        return this.StudyDate;
    }

    public int getWindowCenter() {
        return this.wc;
    }

    public int getWindowWidth() {
        return this.ww;
    }

    public boolean invertedDisplay() {
        return this.invert;
    }

    public void InvertImage() {
        this.invert = !this.invert;
    }

    public boolean isCenter() {
        return this.center;
    }

    public boolean isNewWindowValue() {
        return this.updateWindow;
    }

    public void reset() {
        this.angle = 0.0;
        this.FlipState = 0;
        this.invert = false;
        this.center = true;
        this.pvC = 0;
        this.pvW = 0;
        this.max = 0.0;
        this.min = 0.0;
        this.wc = 0;
        this.ww = 0;
    }

    public void setAngle(double deg) {
        this.angle += deg;
        if (this.angle == 360.0) {
            this.angle = 0.0;
        }
        if (this.angle < 0.0) {
            this.angle = 360.0 + deg;
        }
    }

    public void setAnnotation() {
        annotation = !annotation;
    }

    public void setCenter(boolean stat) {
        this.center = stat;
    }

    public void setImagePosition(int x, int y) {
        this.ImagePosition.setLocation(x, y);
    }

    public void setLoupeSize(int ls) {
        LoupeSize = ls;
    }

    public void setMagnifyZoom(int mz) {
        MagnifyZoom = mz;
    }

    public void setMinAndMax(double min, double max) {
        this.min = min;
        this.max = max;
        this.updateWindow = true;
    }

    public void setPVWC(int w, int c) {
        this.pvW = w;
        this.pvC = c;
    }

    public void setStudyDate(String sd) {
        this.StudyDate = sd;
    }

    public void setScale(double val) {
        this.scale = val > this.SCALE_MAX ? this.SCALE_MAX : (val < this.SCALE_MIN ? this.SCALE_MIN : val);
    }

    public void setWidthAndCenter(int w, int c) {
        this.ww = w;
        if (this.ww < 1) {
            this.ww = 1;
        }
        this.wc = c;
    }

    public void widthHU2PV(int slope) {
        this.pvW = slope != 0 ? this.ww / slope : this.ww;
    }

    public void setPatientBirthDate(String date) {
        this.birth = date;
    }

    public String getPatientBirthDate() {
        return this.birth;
    }
}

