/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import sub.Measurement;

public class ImagePanel
extends JPanel
implements ActionListener {
    Shape ch;
    boolean center = true;
    boolean doUpdate = false;
    boolean isActive = false;
    boolean CineBuffer = false;
    boolean magnifier = false;
    int aIndex;
    int curX;
    int curY;
    int preX;
    int preY;
    int iw;
    int ih;
    int pvW;
    int pvC;
    int xpressed;
    int ypressed;
    int clicks;
    DisplayConfig dc;
    DicomImage di;
    JMenuItem menuItem;
    ViewerCanvas owner;
    JPopupMenu popup;
    HashMap RenderMap;
    Rectangle ROI;
    DecimalFormat format;

    public ImagePanel(ViewerCanvas vc, DicomImage ndi, DisplayConfig dc, int index) {
        this.aIndex = index;
        this.RenderMap = new HashMap();
        this.setDicomImage(ndi, this.aIndex);
        this.owner = vc;
        this.dc = dc;
        this.clicks = 0;
        this.enableEvents(48L);
        this.initPopupMenu();
        this.setBackground(Color.black);
        this.setDoubleBuffered(true);
        this.format = new DecimalFormat("0.0");
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String mText = source.getText();
        if (mText == "Window level") {
            this.owner.setMode(1);
        } else if (mText == "Pan") {
            this.owner.setMode(2);
        } else if (mText == "Magnifying glass") {
            this.owner.setMode(3);
        } else if (mText == "Zoom") {
            this.owner.setMode(4);
        }
    }

    public void addScale(double value) {
        int xfak = (int)((double)this.iw * this.dc.getScale()) / 2;
        int yfak = (int)((double)this.ih * this.dc.getScale()) / 2;
        this.dc.addScale(value);
        this.dc.setImagePosition(this.dc.getImagePosition().x + (xfak -= (int)((double)this.iw * this.dc.getScale()) / 2), this.dc.getImagePosition().y + (yfak -= (int)((double)this.ih * this.dc.getScale()) / 2));
        this.owner.repaint();
    }

    private void draw2Attribute(Graphics g, String info, String sep, String info1, int xstart, int ystart) {
        g.setColor(Color.black);
        int i = 1;
        while (i >= 0) {
            g.drawString(String.valueOf(info) + sep + info1, xstart + i, ystart + i);
            g.setColor(Color.white);
            --i;
        }
    }

    private void drawText(Graphics g, String Text, int xstart, int ystart) {
        if (Text != null) {
            g.setColor(Color.black);
            int i = 1;
            while (i >= 0) {
                g.drawString("" + Text, xstart + i, ystart + i);
                g.setColor(Color.white);
                --i;
            }
        }
    }

    public void fitImage() {
        this.dc.fitImage(this.iw, this.ih, this.getWidth(), this.getHeight());
    }

    public void setCine(boolean state) {
        this.CineBuffer = state;
    }

    public DicomImage getDicomImage() {
        return this.di;
    }

    private Graphics2D getGraphics2D(Graphics g, int InterpolutionType) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.iw > 1500 && this.ih > 1500) {
            InterpolutionType = 3;
        }
        if (InterpolutionType == 1) {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (InterpolutionType == 2) {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        g2.setRenderingHints(this.RenderMap);
        return g2;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public int getImageIndex() {
        return this.aIndex;
    }

    public void update(Graphics g) {
        this.paintComponent(g);
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public void imagePixelUpdate() {
        this.di.update();
    }

    public void initPopupMenu() {
        this.popup = new JPopupMenu();
        this.menuItem = new JMenuItem("Window level");
        this.menuItem.addActionListener(this);
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Pan");
        this.menuItem.addActionListener(this);
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Magnifying glass");
        this.menuItem.addActionListener(this);
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Zoom");
        this.menuItem.addActionListener(this);
        this.popup.add(this.menuItem);
        PopupListener popupListener = new PopupListener(this.popup);
        this.addMouseListener(popupListener);
    }

    private void paintAnnotation(Graphics g) {
        String imgnr = "Image #" + this.di.getXRayNumber();
        g.setFont(new Font("Arial", 0, 14));
        FontMetrics fm = ((Component)this).getFontMetrics(g.getFont());
        g.setColor(Color.black);
        int yspace = 15;
        int ystart = 0;
        int xstart = 0;
        this.drawText(g, this.di.getPatName(), xstart += 5, ystart += 15);
        this.drawText(g, this.dc.getPatientBirthDate(), xstart, ystart += yspace);
        this.drawText(g, this.di.getPatSex(), xstart, ystart += yspace);
        ystart = this.getHeight() - 75;
        if (this.di.isCompressed()) {
            this.drawText(g, "!compressed", xstart, ystart);
            ystart += yspace;
        }
        this.draw2Attribute(g, "" + this.di.getImageWidth(), " x ", "" + this.di.getImageHeight(), xstart, ystart);
        this.drawText(g, "W: " + this.dc.getWindowWidth() + " / L: " + this.dc.getWindowCenter(), xstart, ystart += yspace);
        this.drawText(g, "KVP: " + this.di.getKVP() + " / MAS: " + this.di.getMAS(), xstart, ystart += yspace);
        this.drawText(g, "DSI: " + this.di.getImageDose(), xstart, ystart += yspace);
        this.drawText(g, "XRay Exposure: " + this.di.getXRayExposure(), xstart, ystart += yspace);
        xstart = this.getWidth() - 5;
        ystart = 15;
        this.drawText(g, this.di.getInstitution(), xstart - fm.stringWidth(this.di.getInstitution()), ystart);
        this.drawText(g, this.dc.getStudyDate(), xstart - fm.stringWidth(this.dc.getStudyDate()), ystart += yspace);
        this.drawText(g, "Series # " + this.di.getSeriesNumber(), xstart - fm.stringWidth("Series # " + this.di.getSeriesNumber()), ystart += yspace);
        this.drawText(g, this.di.getModality(), xstart - fm.stringWidth(this.di.getModality()), ystart += yspace);
        this.drawText(g, this.dc.getScalePercent(), xstart - fm.stringWidth(this.dc.getScalePercent()), ystart += yspace);
        ystart = this.getHeight() - 75;
        this.drawText(g, imgnr, xstart - fm.stringWidth(imgnr), ystart);
        this.drawText(g, "Image Time: " + this.di.getImageTime(), xstart - fm.stringWidth("Image Time: " + this.di.getImageTime()), ystart += yspace);
        if (this.di.getModality().equalsIgnoreCase("CT") || this.di.getModality().equalsIgnoreCase("MR")) {
            int yMark;
            int xMark;
            String lMark;
            String rMark;
            this.drawText(g, "Slice Th: " + this.di.getSliceThickness(), xstart - fm.stringWidth("Slice Th: " + this.di.getSliceThickness()), ystart += yspace);
            if (this.dc.getFlipState() >= 2 && this.dc.getAngle() != 180.0 && this.dc.getAngle() != 270.0) {
                rMark = this.di.getLeftMarker();
                lMark = this.di.getRightMarker();
            } else if (this.dc.getFlipState() < 2 && (this.dc.getAngle() == 180.0 || this.dc.getAngle() == 270.0)) {
                rMark = this.di.getLeftMarker();
                lMark = this.di.getRightMarker();
            } else {
                lMark = this.di.getLeftMarker();
                rMark = this.di.getRightMarker();
            }
            if (this.dc.getAngle() == 90.0 || this.dc.getAngle() == 270.0) {
                xstart = this.getWidth() / 2;
                ystart = 15;
                xMark = xstart;
                yMark = this.getHeight() - 5;
            } else {
                xstart = 5;
                ystart = this.getHeight() / 2;
                xMark = this.getWidth() - 5;
                yMark = ystart;
            }
            this.drawText(g, lMark, xstart, ystart);
            xstart = xMark;
            ystart = yMark;
            this.drawText(g, rMark, xstart - fm.stringWidth(rMark), ystart);
        }
        this.drawText(g, this.di.getImageComment(), xstart - fm.stringWidth(this.di.getImageComment()), ystart += yspace);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.DrawImage(g);
    }

    public void DrawImage(Graphics g) {
        if (this.di != null) {
            double angle = 0.0;
            if (this.dc.isCenter()) {
                this.fitImage();
                this.dc.setCenter(false);
            }
            if (this.dc.invertedDisplay() && !this.di.isInverted() || !this.dc.invertedDisplay() && this.di.isInverted()) {
                this.di.doInvert();
                this.di.update();
            }
            Graphics2D g2d = this.getGraphics2D(g, 1);
            AffineTransform at = g2d.getTransform();
            g2d.setColor(Color.black);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            angle = this.owner.isFlipRotateAll() ? this.dc.getAngle() : this.di.getImageAngle();
            g2d.rotate(Math.toRadians(angle), (double)this.dc.getImagePosition().x + (double)this.iw * this.dc.getScale() / 2.0, (double)this.dc.getImagePosition().y + (double)this.ih * this.dc.getScale() / 2.0);
            g2d.translate(this.dc.getImagePosition().x, this.dc.getImagePosition().y);
            g2d.scale(this.dc.getScale(), this.dc.getScale());
            this.paintImage(g2d);
            if (this.owner.getMeasurements().size() > 0) {
                int i = 0;
                while (i < this.owner.getMeasurements().size()) {
                    Measurement.DistanceLine mdl = (Measurement.DistanceLine)this.owner.getMeasurements().elementAt(i);
                    if (mdl.getIndex() == -1 || mdl.getIndex() == this.aIndex) {
                        g2d.setColor(mdl.getColor());
                        g2d.drawLine(mdl.getX1(), mdl.getY1(), mdl.getX2(), mdl.getY2());
                        g2d.setFont(new Font("Arial", 0, 14));
                        g2d.drawString(String.valueOf(mdl.getMeasureValue()) + " " + this.di.getPixelUnit(), mdl.getX1() + 10, mdl.getY1() + 10);
                    }
                    mdl = null;
                    ++i;
                }
            }
            g2d.setTransform(at);
            if (this.ROI != null) {
                g2d.setColor(Color.lightGray);
                g2d.setXORMode(Color.black);
                g2d.drawRect(this.ROI.x, this.ROI.y, this.ROI.width, this.ROI.height);
            }
            if (this.clicks == 1) {
                g2d.setColor(Color.lightGray);
                g2d.setXORMode(Color.black);
                g2d.drawLine(this.xpressed, this.ypressed, this.curX, this.curY);
            }
            if (this.dc.getAnnotation()) {
                this.paintAnnotation(g);
            }
            if (this.di.getPixelUnit().equalsIgnoreCase("mm")) {
                this.paintScale(g);
            }
            if (this.magnifier) {
                double ms = this.dc.getScale() * (double)this.dc.getMagnifyZoom();
                int xpr = this.xpressed - this.dc.getImagePosition().x;
                int ypr = this.ypressed - this.dc.getImagePosition().y;
                int transx = this.dc.getImagePosition().x + (xpr - xpr * this.dc.getMagnifyZoom());
                int transy = this.dc.getImagePosition().y + (ypr - ypr * this.dc.getMagnifyZoom());
                this.ch = new Ellipse2D.Float(this.xpressed - this.dc.getLoupeSize() / 2, this.ypressed - this.dc.getLoupeSize() / 2, this.dc.getLoupeSize(), this.dc.getLoupeSize());
                g2d.setColor(Color.black);
                g2d.clip(this.ch);
                g2d.fill(this.ch);
                g2d.translate(transx, transy);
                g2d.rotate(Math.toRadians(this.dc.getAngle()), (double)this.iw * ms / 2.0, (double)this.ih * ms / 2.0);
                g2d.scale(ms, ms);
                this.paintImage(g2d);
                g2d.setTransform(at);
                g2d.draw(this.ch);
                g2d.setClip(null);
            }
        }
    }

    public void paintImage(Graphics2D g2d) {
        int fs = 0;
        fs = this.owner.isFlipRotateAll() ? this.dc.getFlipState() : this.di.getFlipState();
        if (fs == 0) {
            g2d.drawImage(this.di.getImage(), 0, 0, this);
        } else if (fs == 1) {
            g2d.drawImage(this.di.getImage(), 0, this.ih, this.iw, 0, 0, 0, this.iw, this.ih, this);
        } else if (fs == 2) {
            g2d.drawImage(this.di.getImage(), this.iw, 0, 0, this.ih, 0, 0, this.iw, this.ih, this);
        } else if (fs == 3) {
            g2d.drawImage(this.di.getImage(), this.iw, this.ih, 0, 0, 0, 0, this.iw, this.ih, this);
        }
    }

    public void paintScale(Graphics g) {
        int ScaleTop = this.getHeight() / 2 / 2;
        int ScaleHeight = ScaleTop * 3;
        int ScaleSize = ScaleHeight - ScaleTop;
        g.setColor(Color.white);
        g.drawLine(25, ScaleTop, 25, ScaleHeight);
        g.drawLine(25, ScaleTop, 75, ScaleTop);
        int TickSize = ScaleSize / 10;
        int i = 1;
        while (i < 10) {
            g.drawLine(25, ScaleTop + TickSize * i, i % 2 == 0 ? 50 : 75, ScaleTop + TickSize * i);
            ++i;
        }
        g.drawLine(25, ScaleHeight, 75, ScaleHeight);
        g.drawString(String.valueOf(this.format.format((double)ScaleSize / this.dc.getScale() * this.di.getPixelWidth())) + this.di.getPixelUnit(), 25, ScaleTop - 5);
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getModifiers() == 16) {
            this.owner.setActivePanel(this);
            this.owner.setXRay(this.di.getXRayNumber());
            if (!this.isActive) {
                this.setActive(true);
            }
            this.curX = this.xpressed = e.getX();
            this.curY = this.ypressed = e.getY();
            if (!this.owner.isActive()) {
                this.owner.setActive(true);
            }
            if (this.owner.getMode() == 1) {
                this.setCursor(new Cursor(13));
                this.preX = this.xpressed;
                this.preY = this.ypressed;
            }
            if (this.owner.getMode() == 2) {
                this.setCursor(new Cursor(12));
            }
            if (this.owner.getMode() == 3 || this.owner.getMode() == 4 || this.owner.getMode() == 5 || this.owner.getMode() == 10) {
                this.setCursor(new Cursor(1));
            }
            if (this.owner.getMode() == 3) {
                this.magnifier = true;
                this.repaint();
            }
            if (this.owner.getMode() == 4 || this.owner.getMode() == 2) {
                this.preX = this.xpressed;
                this.preY = this.ypressed;
            }
            if (this.owner.getMode() == 10) {
                ++this.clicks;
            }
        }
        if (e.getID() == 502 && this.owner.getMode() != 10) {
            this.setCursor(new Cursor(0));
            this.magnifier = false;
        }
        if (e.getID() == 502 && this.owner.getMode() == 1 && this.owner.getWindowAll()) {
            this.owner.calibratePanels();
        }
        if (e.getID() == 502 && this.owner.getMode() == 3) {
            this.magnifier = false;
            this.repaint();
        }
        if (e.getID() == 502 && (this.owner.getMode() == 4 || this.owner.getMode() == 2)) {
            this.owner.repaint();
        }
        if (e.getID() == 502 && this.owner.getMode() == 5) {
            double xf = (double)this.getWidth() * this.dc.getScale() / (double)this.ROI.width;
            double yf = (double)this.getHeight() * this.dc.getScale() / (double)this.ROI.height;
            int xdiff = (int)((double)(this.ROI.x - this.dc.getImagePosition().x) / this.dc.getScale());
            int ydiff = (int)((double)(this.ROI.y - this.dc.getImagePosition().y) / this.dc.getScale());
            if (xf <= yf) {
                this.dc.setScale(xf);
            } else if (yf < xf) {
                this.dc.setScale(yf);
            }
            this.dc.setImagePosition(-((int)((double)xdiff * this.dc.getScale())), -((int)((double)ydiff * this.dc.getScale())));
            this.ROI = null;
            this.owner.repaint();
            this.owner.setMode(0);
        }
        if (e.getID() == 502 && this.owner.getMode() == 10 && this.clicks == 2) {
            this.clicks = 0;
            this.preX -= this.dc.getImagePosition().x;
            this.preX = (int)((double)this.preX / this.dc.getScale());
            this.preY -= this.dc.getImagePosition().y;
            this.preY = (int)((double)this.preY / this.dc.getScale());
            this.curX -= this.dc.getImagePosition().x;
            this.curX = (int)((double)this.curX / this.dc.getScale());
            this.curY -= this.dc.getImagePosition().y;
            this.curY = (int)((double)this.curY / this.dc.getScale());
            int vmin = Math.min(this.iw, this.ih);
            int vmax = Math.max(this.iw, this.ih);
            int vdif = (vmax - vmin) / 2;
            if (this.dc.getAngle() == 90.0) {
                this.owner.getMeasurements().addLineMeasure(this.preY - vdif, this.iw - this.preX + vdif, this.curY - vdif, this.iw - this.curX + vdif, this.aIndex, this.di.getPixelWidth());
            } else if (this.dc.getAngle() == 180.0) {
                this.owner.getMeasurements().addLineMeasure(this.iw - this.preX, this.ih - this.preY, this.iw - this.curX, this.ih - this.curY, this.aIndex, this.di.getPixelWidth());
            } else if (this.dc.getAngle() == 270.0) {
                this.owner.getMeasurements().addLineMeasure(this.ih - this.preY - vdif, this.preX + vdif, this.ih - this.curY - vdif, this.curX + vdif, this.aIndex, this.di.getPixelWidth());
            } else {
                this.owner.getMeasurements().addLineMeasure(this.preX, this.preY, this.curX, this.curY, this.aIndex, this.di.getPixelWidth());
            }
            this.owner.setMode(0);
            this.setCursor(new Cursor(0));
            if (Measurement.getLevel() == 0) {
                this.repaint();
            } else {
                this.owner.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && e.getModifiers() == 16) {
            if (this.owner.getMode() == 1) {
                int xval = (e.getX() - this.preX) * 8;
                int yval = (e.getY() - this.preY) * 8;
                int w = this.dc.getWindowWidth();
                int c = this.dc.getWindowCenter();
                if (w <= 1) {
                    w = 1;
                }
                if (!this.di.is8Bit() && c == 0) {
                    c = this.di.getWindowCenter();
                }
                this.preX = e.getX();
                this.preY = e.getY();
                this.dc.setWidthAndCenter(w + xval, c - yval);
                this.dc.widthHU2PV(this.di.getSlope());
                this.dc.centerHU2PV(this.di.getSlope(), this.di.getIntercept());
                this.di.setPVWC(this.dc.getPVW(), this.dc.getPVC());
                this.repaint();
            } else if (this.owner.getMode() == 2) {
                int xval = e.getX() - this.preX;
                int yval = e.getY() - this.preY;
                this.preX = e.getX();
                this.preY = e.getY();
                this.dc.setImagePosition(this.dc.getImagePosition().x + xval, this.dc.getImagePosition().y + yval);
                this.repaint();
            } else if (this.owner.getMode() == 3) {
                this.xpressed = e.getX();
                this.ypressed = e.getY();
                this.repaint();
            } else if (this.owner.getMode() == 4) {
                double val = (double)(e.getY() - this.preY) / 100.0;
                this.preY = e.getY();
                int xfak = (int)((double)this.iw * this.dc.getScale()) / 2;
                int yfak = (int)((double)this.ih * this.dc.getScale()) / 2;
                this.dc.addScale(val);
                this.dc.setImagePosition(this.dc.getImagePosition().x + (xfak -= (int)((double)this.iw * this.dc.getScale()) / 2), this.dc.getImagePosition().y + (yfak -= (int)((double)this.ih * this.dc.getScale()) / 2));
                this.repaint();
            } else if (this.owner.getMode() == 5) {
                int endy;
                int starty;
                int endx;
                int startx;
                if (this.ROI == null) {
                    this.ROI = new Rectangle();
                }
                if (e.getX() > this.xpressed) {
                    startx = this.xpressed;
                    endx = e.getX();
                } else {
                    startx = e.getX();
                    endx = this.xpressed;
                }
                if (e.getY() > this.ypressed) {
                    starty = this.ypressed;
                    endy = e.getY();
                } else {
                    starty = e.getY();
                    endy = this.ypressed;
                }
                this.ROI.setBounds(startx, starty, endx - startx, endy - starty);
                this.repaint();
            }
        } else if (this.owner.getMode() == 10 && e.getID() == 503 && this.clicks == 1) {
            this.curX = e.getX();
            this.curY = e.getY();
            this.preX = this.xpressed;
            this.preY = this.ypressed;
            this.repaint();
        } else {
            super.processMouseMotionEvent(e);
        }
    }

    public void setActive(boolean stat) {
        this.isActive = stat;
        if (this.isActive) {
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 2));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.repaint();
    }

    public void setDicomImage(DicomImage ndi, int index) {
        if (this.di != null && !this.CineBuffer) {
            this.di.dispose();
            this.di = null;
        }
        this.aIndex = index;
        this.di = ndi;
        this.iw = this.di.getImageWidth();
        this.ih = this.di.getImageHeight();
    }

    public void setScale(double value) {
        int xfak = (int)((double)this.iw * this.dc.getScale()) / 2;
        int yfak = (int)((double)this.ih * this.dc.getScale()) / 2;
        this.dc.setScale(value);
        this.dc.setImagePosition(this.dc.getImagePosition().x + (xfak -= (int)((double)this.iw * this.dc.getScale()) / 2), this.dc.getImagePosition().y + (yfak -= (int)((double)this.ih * this.dc.getScale()) / 2));
        this.owner.repaint();
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }
}

