/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public abstract class ImageProcessor {
    public static final int BLACK = -16777216;
    public static final int RED_LUT = 0;
    public static final int BLACK_AND_WHITE_LUT = 1;
    public static final int NO_LUT_UPDATE = 2;
    public static final int OVER_UNDER_LUT = 3;
    static final int INVERT = 0;
    static final int FILL = 1;
    static final int ADD = 2;
    static final int MULT = 3;
    static final int AND = 4;
    static final int OR = 5;
    static final int XOR = 6;
    static final int GAMMA = 7;
    static final int LOG = 8;
    static final int MINIMUM = 9;
    static final int MAXIMUM = 10;
    static final int SQR = 11;
    static final int SQRT = 12;
    static final String WRONG_LENGTH = "(width*height) != pixels.length";
    int fgColor = 0;
    protected int width;
    protected int height;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected ColorModel baseCM;
    protected ColorModel cm;
    protected byte[] rLUT1;
    protected byte[] gLUT1;
    protected byte[] bLUT1;
    protected byte[] rLUT2;
    protected byte[] gLUT2;
    protected byte[] bLUT2;
    protected MemoryImageSource source;
    protected Image img;
    protected boolean newPixels;
    protected Color drawingColor = Color.black;
    protected boolean inversionTested = false;
    protected boolean invertedLut = false;
    protected int defaultCenter;
    protected int defaultWidth;

    public abstract void hu2pv();

    public abstract Image pixelUpdate();

    public abstract void setPVWC(int var1, int var2);

    public abstract Image createImage();

    public void resetMinAndMax() {
    }

    public abstract double getMin();

    public abstract double getMax();

    public abstract void setMinAndMax(double var1, double var3);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        if (this.img == null) {
            this.createImage();
        }
        return this.img;
    }

    public ColorModel getColorModel() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.baseCM != null) {
            return this.baseCM;
        }
        return this.cm;
    }

    public void setColorModel(ColorModel cm) {
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Must be IndexColorModel");
        }
        this.cm = cm;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.newPixels = true;
        this.inversionTested = false;
    }

    protected void makeDefaultColorModel() {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int i = 0;
        while (i < 256) {
            rLUT[i] = (byte)i;
            gLUT[i] = (byte)i;
            bLUT[i] = (byte)i;
            ++i;
        }
        this.cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }

    void resetPixels(Object pixels) {
        if (pixels == null) {
            if (this.img != null) {
                this.img.flush();
                this.img = null;
            }
            this.source = null;
        }
        this.newPixels = true;
    }

    public void invertLut() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] reds2 = new byte[mapSize];
        byte[] greens2 = new byte[mapSize];
        byte[] blues2 = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        int i = 0;
        while (i < mapSize) {
            reds2[i] = (byte)(reds[mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(greens[mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(blues[mapSize - i - 1] & 0xFF);
            ++i;
        }
        this.cm = new IndexColorModel(8, mapSize, reds2, greens2, blues2);
        this.newPixels = true;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
        this.invertedLut = !this.invertedLut;
    }

    public boolean isInvertedLut() {
        if (this.inversionTested) {
            return this.invertedLut;
        }
        this.inversionTested = true;
        if (this.cm == null || !(this.cm instanceof IndexColorModel)) {
            this.invertedLut = false;
            return false;
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        this.invertedLut = true;
        int i = 1;
        while (i < 255) {
            int v2;
            int v1 = icm.getRed(i - 1) + icm.getGreen(i - 1) + icm.getBlue(i - 1);
            if (v1 < (v2 = icm.getRed(i) + icm.getGreen(i) + icm.getBlue(i))) {
                this.invertedLut = false;
                break;
            }
            ++i;
        }
        return this.invertedLut;
    }
}

