/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import sub.MainLayout;
import sub.Measurement;

public class MeDiViewer
extends JFrame {
    public MainDisplay mDisplay;
    public MainLayout ml;
    public SeriesCanvas canvas;
    public TopoCanvas tc;
    public static int WIDTH_CR;
    public static int LEVEL_CR;
    public static int WIDTH_CT;
    public static int LEVEL_CT;
    public static int WIDTH_MR;
    public static int LEVEL_MR;
    public boolean SpecialDisplay;
    int SeriesTotal;
    int DISPLAY_MATRIX;
    int TimerModus;
    int ScoutFolders;
    Properties pt;
    Object[] ViewPorts;
    ViewerCanvas ActiveCanvas;
    String UserDir;
    About abFrame;
    DicomInfo infoFrame;
    AnimationTimer ani;
    static /* synthetic */ Class class$0;

    public MeDiViewer(String title) {
        super(title);
        this.init();
        this.loadStudy(null, 0);
        ((Component)this).setVisible(true);
        this.requestFocus();
    }

    public void init() {
        int screenH = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenW = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.TimerModus = 0;
        Measurement.setColor(Color.red);
        ((Component)this).setSize(screenW, screenH - 30);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.pt = new Properties();
        this.UserDir = System.getProperty("user.dir").replace('\\', '/');
        this.pt.setProperty("LANGUAGE", "english");
        try {
            URL url = new URL("file:///" + this.UserDir + "/properties.dat");
            InputStream is = (InputStream)url.getContent();
            DataInputStream dis = new DataInputStream(is);
            this.pt.load(dis);
            is.close();
            dis.close();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "MeDiViewer Error", 0);
            System.exit(0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "MeDiViewer Error", 0);
            System.exit(0);
        }
        this.pt.setProperty("BONE_WINDOW", "2500");
        this.pt.setProperty("BONE_CENTER", "500");
        this.pt.setProperty("ABDOMEN_WINDOW", "350");
        this.pt.setProperty("ABDOMEN_CENTER", "50");
        this.pt.setProperty("CEREBRUM_WINDOW", "120");
        this.pt.setProperty("CEREBRUM_CENTER", "40");
        this.pt.setProperty("LUNG_WINDOW", "1500");
        this.pt.setProperty("LUNG_CENTER", "-500");
        WIDTH_CR = Integer.parseInt(this.pt.getProperty("WIDTH_CR", "3000"));
        LEVEL_CR = Integer.parseInt(this.pt.getProperty("LEVEL_CR", "1500"));
        WIDTH_CT = Integer.parseInt(this.pt.getProperty("WIDTH_CT", "300"));
        LEVEL_CT = Integer.parseInt(this.pt.getProperty("LEVEL_CT", "150"));
        WIDTH_MR = Integer.parseInt(this.pt.getProperty("WIDTH_MR", "150"));
        LEVEL_MR = Integer.parseInt(this.pt.getProperty("LEVEL_MR", "75"));
        this.ScoutFolders = Integer.parseInt(this.pt.getProperty("SCOUT_FOLDERS", "0"));
        this.SeriesTotal = Integer.parseInt(this.pt.getProperty("SERIES_TOTAL"));
        this.ViewPorts = new Object[4];
        int i = 0;
        while (i < this.ViewPorts.length) {
            this.ViewPorts[i] = new ViewerCanvas(this);
            ++i;
        }
        this.canvas = new SeriesCanvas(this);
        this.ani = new AnimationTimer(this);
        this.mDisplay = new MainDisplay(this, this.ViewPorts);
        this.DISPLAY_MATRIX = 1;
        this.ml = new MainLayout(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("MeDiViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((Frame)this).setIconImage(new ImageIcon(clazz.getResource("images/sst.gif")).getImage());
        this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
        this.mDisplay.add((Component)this.ActiveCanvas, 0);
    }

    public void doCommand(int action) {
        if (action == 99) {
            System.exit(0);
        } else if (action == 0) {
            if (this.DISPLAY_MATRIX != 1 && !this.SpecialDisplay) {
                this.mDisplay.setRowCol(1, 1);
                this.mDisplay.updateContent(1);
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.ActiveCanvas.fitImages();
                this.DISPLAY_MATRIX = 1;
            }
        } else if (action == 1) {
            if (this.SeriesTotal >= 2 && this.DISPLAY_MATRIX != 2 && !this.SpecialDisplay) {
                this.mDisplay.setRowCol(2, 1);
                this.mDisplay.updateContent(2);
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.mDisplay.resizeComponents();
                this.DISPLAY_MATRIX = 2;
            }
        } else if (action == 2) {
            if (this.SeriesTotal >= 2 && this.DISPLAY_MATRIX != 3 && !this.SpecialDisplay) {
                this.mDisplay.setRowCol(1, 2);
                this.mDisplay.updateContent(2);
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.mDisplay.resizeComponents();
                this.DISPLAY_MATRIX = 3;
            }
        } else if (action == 3) {
            if (this.SeriesTotal >= 4 && this.DISPLAY_MATRIX != 4 && !this.SpecialDisplay) {
                this.mDisplay.setRowCol(2, 2);
                this.mDisplay.updateContent(4);
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.mDisplay.resizeComponents();
                this.DISPLAY_MATRIX = 4;
            }
        } else if (action == 4) {
            this.getActiveCanvas().setRowCol(1, 1);
        } else if (action == 5) {
            this.getActiveCanvas().setRowCol(2, 1);
        } else if (action == 6) {
            this.getActiveCanvas().setRowCol(1, 2);
        } else if (action == 7) {
            this.getActiveCanvas().setRowCol(2, 2);
        } else if (action == 8) {
            this.getActiveCanvas().setRowCol(3, 3);
        } else if (action == 9) {
            this.getActiveCanvas().setRowCol(4, 4);
        } else if (action == 51) {
            this.SpecialDisplay = !this.SpecialDisplay;
            if (this.SpecialDisplay) {
                this.tc = new TopoCanvas(this.ScoutFolders);
                this.mDisplay.setSpecialLayout(this.tc);
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.LoadTopogramm();
                this.ActiveCanvas.fitImages();
                this.ActiveCanvas.setRowCol(1, 1);
                this.DISPLAY_MATRIX = 1;
            } else {
                this.mDisplay.resetDisplay();
                this.setActiveCanvas((ViewerCanvas)this.ViewPorts[0]);
                this.ActiveCanvas.fitImages();
                this.DISPLAY_MATRIX = 1;
                this.tc = null;
            }
        } else if (action == 10) {
            this.getActiveCanvas().gotoLeftRightEnd(true);
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 15) {
            this.getActiveCanvas().fastRewind();
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 13) {
            this.getActiveCanvas().rewind();
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 12) {
            this.getActiveCanvas().forward();
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 14) {
            this.getActiveCanvas().fastForward();
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 11) {
            this.getActiveCanvas().gotoLeftRightEnd(false);
            if (this.SpecialDisplay) {
                this.LoadTopogramm();
            }
        } else if (action == 17) {
            int stat = this.getActiveCanvas().rewindAnimation(this.TimerModus);
            if (stat == 0) {
                this.getActiveCanvas().rewind();
            } else {
                this.ani.setModus(stat);
            }
        } else if (action == 16) {
            int stat = this.getActiveCanvas().forwardAnimation(this.TimerModus);
            if (stat == 0) {
                this.getActiveCanvas().forward();
            } else {
                this.ani.setModus(stat);
            }
        } else if (action == 18) {
            this.getActiveCanvas().setMode(1);
        } else if (action == 19) {
            this.getActiveCanvas().setMode(2);
        } else if (action == 20) {
            this.getActiveCanvas().setMode(3);
        } else if (action == 21) {
            this.getActiveCanvas().setMode(4);
        } else if (action == 22) {
            this.getActiveCanvas().setMode(5);
        } else if (action == 26) {
            this.getActiveCanvas().setMode(10);
        } else if (action == 27) {
            this.getActiveCanvas().clearMeasurements();
        } else if (action == 23) {
            this.getActiveCanvas().getActivePanel().addScale(0.1);
        } else if (action == 24) {
            this.getActiveCanvas().getActivePanel().addScale(-0.1);
        } else if (action == 25) {
            this.getActiveCanvas().getActivePanel().setScale(1.0);
        } else if (action == 28) {
            if (!this.ani.getStatus()) {
                this.getActiveCanvas().fitImages();
            }
        } else if (action == 29) {
            this.getActiveCanvas().getDisplayConfig().InvertImage();
            this.getActiveCanvas().repaint();
        } else if (action == 31) {
            this.getActiveCanvas().getDisplayConfig().FlipHorizontal();
            this.getActiveCanvas().repaint();
        } else if (action == 30) {
            this.getActiveCanvas().getDisplayConfig().FlipVertical();
            this.getActiveCanvas().repaint();
        } else if (action == 32) {
            if (this.getActiveCanvas().isFlipRotateAll()) {
                this.getActiveCanvas().getDisplayConfig().setAngle(90.0);
            } else {
                this.getActiveCanvas().getActivePanel().getDicomImage().RotateClockwise();
            }
            this.getActiveCanvas().repaint();
        } else if (action == 33) {
            if (this.getActiveCanvas().isFlipRotateAll()) {
                this.getActiveCanvas().getDisplayConfig().setAngle(-90.0);
            } else {
                this.getActiveCanvas().getActivePanel().getDicomImage().RotateAntiClockwise();
            }
            this.getActiveCanvas().repaint();
        } else if (action == 34) {
            this.setPreset(1, "CEREBRUM_WINDOW", "CEREBRUM_CENTER");
        } else if (action == 35) {
            this.setPreset(2, "ABDOMEN_WINDOW", "ABDOMEN_CENTER");
        } else if (action == 36) {
            this.setPreset(3, "LUNG_WINDOW", "LUNG_CENTER");
        } else if (action == 37) {
            this.setPreset(4, "BONE_WINDOW", "BONE_CENTER");
        } else if (action == 38) {
            this.startAnimation(1);
        } else if (action == 39) {
            this.startAnimation(2);
        } else if (action == 40) {
            this.startAnimation(3);
        } else if (action == 41) {
            this.getActiveCanvas().disableCineMode();
            this.TimerModus = 0;
            this.ani.stopAnimation();
        } else if (action == 42) {
            this.getActiveCanvas().getDisplayConfig().setAnnotation();
            this.mDisplay.repaintComponents();
        } else if (action == 43) {
            this.getActiveCanvas().resetDisplay();
        } else if (action == 44) {
            Color c = JColorChooser.showDialog(this, "Measurement color", Color.red);
            this.ml.setMeasureButtonColor(c);
            Measurement.setColor(c);
        } else if (action == 45) {
            if (this.infoFrame != null) {
                this.infoFrame.dispose();
                this.infoFrame = null;
            }
            this.infoFrame = new DicomInfo(this.ActiveCanvas.getActiveDicomImage().getHeaderInformation());
            this.infoFrame.setTitle("Header Information from selected image.");
            ((Component)this.infoFrame).setSize(600, 400);
            ((Component)this.infoFrame).setVisible(true);
        } else if (action == 52) {
            this.getActiveCanvas().SwitchWindowAll();
        } else if (action == 53) {
            this.getActiveCanvas().SwitchFlipRotateAll();
        } else if (action == 46) {
            if (this.abFrame == null) {
                this.abFrame = new About();
            }
            ((Component)this.abFrame).setVisible(true);
        } else if (action == 50) {
            this.getActiveCanvas().showPrintPreview();
        }
    }

    public String getProperty(String key) {
        if (this.pt.getProperty(key) == null) {
            return "";
        }
        return this.pt.getProperty(key);
    }

    public String getProperty(String key, String def) {
        if (this.pt.getProperty(key) == null) {
            return def;
        }
        return this.pt.getProperty(key);
    }

    private void LoadTopogramm() {
        this.tc.setImageFile(this.ActiveCanvas.getPanel(0).getDicomImage().getInstanceUID());
    }

    private void startAnimation(int mod) {
        if (!this.ani.getStatus()) {
            if (this.getActiveCanvas().getImageCount() > 2) {
                this.getActiveCanvas().enableCineMode();
                this.getActiveCanvas().setRowCol(1, 1);
                this.TimerModus = mod;
                this.ani.startAnimation(this.TimerModus);
            }
        } else {
            this.TimerModus = mod;
            this.ani.setModus(this.TimerModus);
        }
    }

    private void setPreset(int pre, String pw, String pc) {
        int w = Integer.parseInt(this.pt.getProperty(pw));
        int c = Integer.parseInt(this.pt.getProperty(pc));
        this.ActiveCanvas.getDisplayConfig().setWidthAndCenter(w, c);
        int slope = this.ActiveCanvas.getPanel(0).getDicomImage().getSlope();
        int intercept = this.ActiveCanvas.getPanel(0).getDicomImage().getIntercept();
        this.ActiveCanvas.getDisplayConfig().centerHU2PV(slope, intercept);
        this.ActiveCanvas.getDisplayConfig().widthHU2PV(slope);
        this.ActiveCanvas.setActivePanel(null);
        if (this.ActiveCanvas.getComponentCount() > 1) {
            this.ActiveCanvas.calibratePanels();
        } else {
            this.ActiveCanvas.calibratePanel(null);
        }
    }

    public void loadStudy(ViewerCanvas can, int index) {
        int ImgTotal = 0;
        if (can == null) {
            can = this.getActiveCanvas();
        }
        if (can == this.ActiveCanvas && this.TimerModus != 0) {
            this.doCommand(41);
        }
        if (index != can.getStudyID()) {
            Stack is = can.getImageStack();
            if (can.getComponentCount() > 0) {
                can.removeAll();
            }
            if (is != null) {
                is.clear();
            } else {
                is = new Stack();
            }
            String sInd = "SERIE" + (index + 1);
            String ImageDir = this.pt.getProperty(String.valueOf(sInd) + "_FOLDER");
            String birth = this.pt.getProperty(String.valueOf(sInd) + "_PATIENT_BIRTHDATE", "00.00.0000");
            String sd = this.pt.getProperty(String.valueOf(sInd) + "_STUDYDATE", "00.00.0000");
            ImgTotal = Integer.parseInt(this.pt.getProperty(String.valueOf(sInd) + "_IMAGES"));
            int i = 0;
            while (i < ImgTotal) {
                OpenDicom.fromFile(is, String.valueOf(this.UserDir) + "/" + ImageDir, this.pt.getProperty(String.valueOf(sInd) + "_IMAGE" + (i + 1)), i);
                ++i;
            }
            can.setImageStack(is, index);
            DicomImage di = can.getPanel(0).getDicomImage();
            int ww = di.getWindowWidth();
            int wc = di.getWindowCenter();
            DisplayConfig dc = can.getDisplayConfig();
            dc.setWidthAndCenter(ww, wc);
            dc.setPatientBirthDate(birth);
            dc.centerHU2PV(di.getSlope(), di.getIntercept());
            dc.widthHU2PV(di.getSlope());
            di.setPVWC(dc.getPVW(), dc.getPVC());
            dc.setStudyDate(sd);
            if (this.SpecialDisplay) {
                this.tc.setImageFile(di.getInstanceUID());
            }
            is = null;
        } else {
            ImgTotal = Integer.parseInt(this.pt.getProperty("SERIE" + (index + 1) + "_IMAGES"));
        }
        if (can == this.ActiveCanvas) {
            String desc = this.getProperty("SERIE" + (index + 1) + "_DESCRIPTION");
            String patname = this.getProperty("SERIE" + (index + 1) + "_PATIENT_NAME");
            String patid = this.getProperty("SERIE" + (index + 1) + "_PATIENT_ID");
            if (desc.length() == 0) {
                desc = "Unknown";
            }
            if (patname.length() == 0) {
                patname = "Unkown";
            }
            this.ml.updateInformation(patname, patid, desc, "", "" + ImgTotal);
        }
    }

    public void setLoupeSize(int s) {
        this.getActiveCanvas().getDisplayConfig().setLoupeSize(s);
    }

    public void setMagnifyZoom(int z) {
        this.getActiveCanvas().getDisplayConfig().setMagnifyZoom(z);
    }

    public void setAnimationSpeed(int speed) {
        this.ml.setSpeedSliderText(String.valueOf(this.ml.getSpeedSliderValue()) + " frames/sec");
        this.ani.setSpeed(speed);
    }

    public int getTimerStatus() {
        return this.TimerModus;
    }

    public ViewerCanvas getActiveCanvas() {
        if (this.ActiveCanvas != null) {
            return this.ActiveCanvas;
        }
        return (ViewerCanvas)this.ViewPorts[0];
    }

    public void setActiveCanvas(ViewerCanvas can) {
        if (this.ActiveCanvas != null && can != this.ActiveCanvas) {
            this.ActiveCanvas.setActive(false);
            this.ActiveCanvas.setActivePanel(null);
        }
        this.ActiveCanvas = can;
        this.ActiveCanvas.setOnDisplay(true);
        String desc = this.getProperty("SERIE" + (this.ActiveCanvas.getStudyID() + 1) + "_DESCRIPTION");
        String patname = this.getProperty("SERIE" + (this.ActiveCanvas.getStudyID() + 1) + "_PATIENT_NAME");
        String patid = this.getProperty("SERIE" + (this.ActiveCanvas.getStudyID() + 1) + "_PATIENT_ID");
        String birth = this.getProperty("SERIE" + (this.ActiveCanvas.getStudyID() + 1) + "_PATIENT_BIRTHDATE");
        if (desc.length() == 0) {
            desc = "Unknown";
        }
        if (patname.length() == 0) {
            patname = "Unkown";
        }
        this.getActiveCanvas().getDisplayConfig().setPatientBirthDate(birth);
        this.ml.updateInformation(patname, patid, desc, "", "" + this.ActiveCanvas.getImageCount());
    }

    class CompoListener
    extends ComponentAdapter {
        MeDiViewer md;

        public CompoListener(MeDiViewer md) {
            this.md = md;
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.md.mDisplay.resizeComponents();
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

