/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JOptionPane;

public class OpenDicom {
    public static boolean fromFile(Stack is, String path, String file, int id) {
        ColorModel cm;
        FileInfo fi = null;
        DicomDecoderX dd = new DicomDecoderX("file:///" + path + "/", file);
        try {
            fi = dd.getFileInfo();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Loading image failed.\n\n" + e.toString(), "MeDiViewer Error", 0);
            return false;
        }
        fi.fileName = file;
        fi.HeaderDaten = dd.getHeaderDaten();
        fi.cm = cm = OpenDicom.createColorModel(fi);
        is.add(new DicomImage(fi, id));
        return true;
    }

    public static ColorModel createColorModel(FileInfo fi) {
        if (fi.fileType == 5 && fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    static Object readPixels(FileInfo fi) {
        Object pixels = null;
        try {
            InputStream is = OpenDicom.createInputStream(fi);
            if (is == null) {
                return null;
            }
            ImageReader reader = new ImageReader(fi);
            pixels = reader.readPixels(is);
            is.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "MeDiViewer Error", 0);
        }
        return pixels;
    }

    public static InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(String.valueOf(fi.url) + fi.fileName).openStream();
        }
        File f = new File(String.valueOf(fi.directory) + fi.fileName);
        if (f == null || f.isDirectory()) {
            return null;
        }
        return new FileInputStream(f);
    }
}

