/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PrintPreview
extends JFrame
implements ActionListener {
    JPanel tb;
    PreviewPanel pp;
    PageFormat pFormat;
    PrinterJob printJob;

    public PrintPreview() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Print Preview");
        this.pp = new PreviewPanel();
        this.tb = new JPanel();
        this.pFormat = new PageFormat();
        JButton print = new JButton("Print");
        print.addActionListener(this);
        print.setActionCommand("print");
        JButton setup = new JButton("Page Setup");
        setup.addActionListener(this);
        setup.setActionCommand("setup");
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("cancel");
        this.tb.add(print);
        this.tb.add(setup);
        this.tb.add(cancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pp, "Center");
        this.getContentPane().add((Component)this.tb, "South");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "print") {
            this.pp.print();
            this.requestFocus();
            this.dispose();
        } else if (cmd == "setup") {
            PageFormat tmpFormat;
            this.printJob = PrinterJob.getPrinterJob();
            this.pFormat = tmpFormat = this.printJob.pageDialog(this.pFormat);
            this.requestFocus();
        } else {
            this.dispose();
        }
    }

    public void setPreviewImage(Image img) {
        ((Component)this).setSize((int)((double)img.getWidth(null) * 0.8), (int)((double)img.getWidth(null) * 0.8));
        this.validate();
        this.pp.setImage(img);
        this.repaint();
    }

    class PreviewPanel
    extends JPanel
    implements Printable {
        Image prev;
        int hc;
        int vc;
        Date d;
        double scale;

        public PreviewPanel() {
            this.setBackground(Color.black);
            this.d = new Date();
        }

        public void paintComponent(Graphics g) {
            if (this.prev != null) {
                this.hc = this.getWidth() / 2 - (int)((double)this.prev.getWidth(null) * 0.75 / 2.0);
                this.vc = this.getHeight() / 2 - (int)((double)this.prev.getHeight(null) * 0.75 / 2.0);
                Graphics2D g2 = (Graphics2D)g;
                this.drawImage(g2, 0.75);
            }
        }

        public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
            if (page > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            this.scale = pf.getWidth() < pf.getHeight() ? pf.getWidth() / (double)this.prev.getWidth(null) : pf.getHeight() / (double)this.prev.getHeight(null);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(this.scale, this.scale);
            this.setDoubleBuffered(false);
            this.paint(g2d);
            this.setDoubleBuffered(true);
            return 0;
        }

        public void print() {
            PrintPreview.this.printJob = PrinterJob.getPrinterJob();
            PrintPreview.this.printJob.setPrintable(this, PrintPreview.this.pFormat);
            if (PrintPreview.this.printJob.printDialog()) {
                try {
                    PrintPreview.this.printJob.print();
                }
                catch (PrinterException pe) {
                    System.out.println("Error printing: " + pe);
                }
            }
        }

        private void drawImage(Graphics2D g2, double scale) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(Color.black);
            g2.drawString("printed on: " + DateFormat.getInstance().format(this.d), this.hc - 5, this.vc - 20);
            g2.scale(scale, scale);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(this.prev, this.hc, this.vc, null);
        }

        public void setImage(Image img) {
            this.prev = img;
        }
    }
}

