/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import sub.FindWhereInComp;

public class SeriesCanvas
extends JComponent {
    protected MeDiViewer md;
    private int lastSel = -1;
    int stampW;
    int stampH = this.stampW = 80;
    int hgap = 10;
    int vgap = 10;
    FindWhereInComp fwic;
    final Font f = new Font("Arial", 1, 10);
    FontMetrics fm = ((Component)this).getFontMetrics(this.f);
    private Image[] icons;

    public SeriesCanvas(MeDiViewer md) {
        this.md = md;
        this.setBackground(Color.black);
        this.setDoubleBuffered(true);
        this.enableEvents(16L);
        this.setPreferredSize(new Dimension(300, 500));
        this.lastSel = -1;
        this.initIcons();
    }

    private void initIcons() {
        this.icons = new Image[this.md.SeriesTotal];
        String path = System.getProperty("user.dir").replace('\\', '/');
        MediaTracker mt = new MediaTracker(this);
        int i = 0;
        while (i < this.icons.length) {
            this.icons[i] = Toolkit.getDefaultToolkit().createImage(String.valueOf(path) + "/" + this.md.getProperty("SERIE" + (i + 1) + "_FOLDER") + "/icon.jpg");
            mt.addImage(this.icons[i], i);
            try {
                mt.waitForID(i);
            }
            catch (InterruptedException ie) {
                JOptionPane.showMessageDialog(null, ie.toString(), "MeDiViewer Error", 0);
                System.exit(0);
            }
            ++i;
        }
    }

    public void update(Graphics g) {
        this.paintComponent(g);
    }

    public void paintComponent(Graphics g) {
        int i = 0;
        while (i < this.icons.length) {
            this.paintStamp(g, i, this.icons[i]);
            ++i;
        }
        this.paintSelected(g);
    }

    public void paintSelected(Graphics g) {
        int mod = this.getSize().width / this.stampW;
        if (mod == 0) {
            mod = 400;
        }
        int xRect = this.lastSel % mod * (this.stampW + this.hgap);
        int yRect = this.lastSel / mod;
        g.setColor(Color.blue);
        g.draw3DRect(xRect, yRect *= this.stampH + this.vgap, this.stampW, this.stampH, true);
    }

    public void paintStamp(Graphics g, int number, Image img) {
        g.setFont(this.f);
        g.setColor(Color.white);
        int numRow = this.getSize().width / this.stampW;
        int xPos = number % numRow * (this.stampW + this.hgap);
        int yPos = number / numRow;
        if ((yPos *= this.stampH + this.vgap) + this.stampH > this.getSize().height) {
            this.setSize(this.getSize().width, yPos + this.stampH + 10);
        }
        g.drawImage(img, xPos, yPos, this.stampW, this.stampH, this);
        g.setColor(Color.lightGray);
        g.draw3DRect(xPos, yPos, this.stampW, this.stampH, true);
    }

    public void open() {
        if (this.lastSel == -1) {
            return;
        }
        this.setCursor(new Cursor(3));
        this.md.loadStudy(null, this.lastSel);
    }

    public void processMouseEvent(MouseEvent e) {
        this.setCursor(new Cursor(12));
        if (e.getID() == 501) {
            if (this.fwic == null) {
                this.fwic = new FindWhereInComp(this, this.stampW, this.stampH);
            }
            if (this.lastSel != -1) {
                if (this.fwic == null) {
                    return;
                }
                this.fwic.clearRect(this.lastSel);
                this.lastSel = -1;
            }
            this.lastSel = this.fwic.findWhere(e.getX(), e.getY(), this.icons.length);
            this.paintSelected(this.getGraphics());
            this.open();
        } else if (e.getID() == 505) {
            this.setCursor(new Cursor(0));
        } else {
            super.processMouseEvent(e);
        }
    }

    public void markObject(int objIndex) {
        if (this.lastSel != -1 && this.fwic != null) {
            this.fwic.clearRect(this.lastSel);
        }
        if (this.fwic == null) {
            this.fwic = new FindWhereInComp(this, this.stampW, this.stampH);
        }
        this.lastSel = objIndex;
        this.paintSelected(this.getGraphics());
    }
}

