/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class ShortProcessor
extends ImageProcessor {
    private int currentWidth;
    private int currentCenter;
    private int defaultWidth;
    private int defaultCenter;
    private FileInfo fi;
    private boolean findMinMax = false;
    private int min;
    private int max;
    private short[] pixels;
    private byte[] pixels8;
    private short MaxGray;

    public ShortProcessor(int width, int height, short[] pixels, ColorModel cm, FileInfo fi) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.fi = fi;
        this.cm = cm;
        if (fi.bitsStored <= 12) {
            this.MaxGray = (short)4095;
        } else if (fi.bitsStored == 16) {
            this.MaxGray = Short.MAX_VALUE;
        }
        if (fi.ModalityLut) {
            int i = 0;
            while (i < this.pixels.length) {
                short pval = this.pixels[i];
                pval = pval < fi.mDescriptor[1] ? (short)0 : (pval > fi.mDescriptor[0] + fi.mDescriptor[1] ? this.MaxGray : (pval - fi.mDescriptor[1] < fi.LutData.length ? (short)fi.LutData[pval - fi.mDescriptor[1]] : this.MaxGray));
                this.pixels[i] = pval;
                ++i;
            }
            this.findMinAndMax();
        } else {
            this.hu2pv();
        }
    }

    public void findMinAndMax() {
        int size = this.width * this.height;
        this.min = 65535;
        this.max = 0;
        int i = 0;
        while (i < size) {
            int value = this.pixels[i] & 0xFFFF;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            ++i;
        }
        this.currentWidth = this.max;
        this.currentCenter = this.min;
    }

    public void hu2pv() {
        this.currentCenter = 0;
        this.currentWidth = 0;
        if (this.fi.slope <= 0) {
            this.fi.slope = 1;
        }
        this.defaultCenter = this.fi.windowCenter - this.fi.intercept / this.fi.slope;
        this.defaultWidth = this.fi.windowWidth / this.fi.slope;
        this.calculateMinAndMax();
    }

    public Image createImage() {
        this.img = null;
        if (!this.findMinMax) {
            this.calculateMinAndMax();
        }
        int size = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[size];
        }
        double scale = 256.0 / (double)(this.max - this.min + 1);
        int i = 0;
        while (i < size) {
            int value = (this.pixels[i] & 0xFFFF) - this.min;
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * scale)) > 255) {
                value = 255;
            }
            this.pixels8[i] = (byte)value;
            ++i;
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels8, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    private void calculateMinAndMax() {
        if (this.currentCenter == 0 && this.currentWidth == 0) {
            this.currentCenter = this.defaultCenter;
            this.currentWidth = this.defaultWidth;
        }
        int theCenter = this.currentCenter;
        int theWidth = this.currentWidth;
        if (theWidth < 1) {
            theWidth = 1;
        }
        this.min = theCenter - theWidth / 2;
        this.max = theCenter + theWidth / 2;
        if (this.fi.fileType == 1) {
            this.min += 32768;
            this.max += 32768;
        }
    }

    public void setPVWC(int cw, int cc) {
        this.currentCenter = cc;
        this.currentWidth = cw;
        if (!this.findMinMax) {
            this.calculateMinAndMax();
        }
    }

    public Image pixelUpdate() {
        int size = this.width * this.height;
        double scale = 256.0 / (double)(this.max - this.min + 1);
        int i = 0;
        while (i < size) {
            int value = (this.pixels[i] & 0xFFFF) - this.min;
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * scale)) > 255) {
                value = 255;
            }
            this.pixels8[i] = (byte)value;
            ++i;
        }
        this.source.newPixels(this.pixels8, this.cm, 0, this.width);
        return this.img;
    }

    public void setMinAndMax(double min, double max) {
        if (max < 0.0) {
            max = 0.0;
        }
        this.min = (int)min;
        this.max = (int)max;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }
}

