/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TopoCanvas
extends JPanel {
    HashMap RenderMap = new HashMap();
    String ImageFile = "";
    Image TopoImage = null;
    Image top;
    Font f = new Font("Arial", 0, 16);
    FontMetrics fm = ((Component)this).getFontMetrics(this.f);
    int iDirs;
    int CurrentDir;
    int xpos;
    int ypos;
    double scl;
    private String path;
    private String ScoutDir;

    public TopoCanvas(int ScoutDirCount) {
        this.setDoubleBuffered(true);
        this.setBackground(Color.black);
        this.enableEvents(16L);
        this.iDirs = ScoutDirCount;
        this.CurrentDir = 0;
        this.path = System.getProperty("user.dir").replace('\\', '/');
        this.ScoutDir = "/scouts/";
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.DrawImage(g);
    }

    public void DrawImage(Graphics g) {
        Graphics2D g2d = this.getGraphics2D(g, 1);
        this.top = this.getImage();
        if (this.top == null) {
            String s = "No image available";
            int x = this.getWidth() / 2 - this.fm.stringWidth(s) / 2;
            int y = this.getHeight() / 2;
            g.setFont(this.f);
            g.setColor(Color.white);
            g.drawString(s, x, y);
        } else {
            this.fitImage();
            g2d.drawImage(this.top, this.xpos, this.ypos, (int)((double)this.top.getWidth(this) * this.scl), (int)((double)this.top.getHeight(this) * this.scl), this);
        }
    }

    public void fitImage() {
        this.scl = this.getWidth() > this.getHeight() ? (double)this.getHeight() / (double)Math.max(this.top.getWidth(this), this.top.getHeight(this)) : (double)this.getWidth() / (double)Math.max(this.top.getWidth(this), this.top.getHeight(this));
        this.centerImage();
    }

    public void centerImage() {
        this.xpos = (int)((double)(this.getWidth() / 2) - (double)this.top.getWidth(this) * this.scl / 2.0);
        this.ypos = (int)((double)(this.getHeight() / 2) - (double)this.top.getHeight(this) * this.scl / 2.0);
    }

    private Image getImage() {
        if (this.ImageFile.length() == 0) {
            return null;
        }
        MediaTracker mt = new MediaTracker(this);
        String Fi = String.valueOf(this.path) + this.ScoutDir + this.ImageFile + ".jpg";
        File f = new File(Fi);
        if (!f.exists()) {
            return null;
        }
        f = null;
        this.TopoImage = Toolkit.getDefaultToolkit().createImage(Fi);
        mt.addImage(this.TopoImage, 1);
        try {
            mt.waitForID(1);
        }
        catch (InterruptedException ie) {
            JOptionPane.showMessageDialog(null, ie.toString(), "MeDiViewer Error", 0);
        }
        return this.TopoImage;
    }

    public void setImageFile(String name) {
        this.ImageFile = name;
        this.repaint();
    }

    private Graphics2D getGraphics2D(Graphics g, int InterpolutionType) {
        Graphics2D g2 = (Graphics2D)g;
        if (InterpolutionType == 1) {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (InterpolutionType == 2) {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            this.RenderMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        g2.setRenderingHints(this.RenderMap);
        return g2;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 500 && this.iDirs > 1) {
            if (this.CurrentDir < this.iDirs - 1) {
                ++this.CurrentDir;
                this.ScoutDir = "/scouts" + this.CurrentDir + "/";
            } else if (this.CurrentDir == this.iDirs - 1) {
                this.CurrentDir = 0;
                this.ScoutDir = "/scouts/";
            }
            this.repaint();
        }
    }
}

