/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import sub.Measurement;

public class ViewerCanvas
extends JComponent {
    static int mode;
    int ActivePanel;
    int index;
    int sid;
    int xray;
    int rows;
    int columns;
    ImagePanel ip;
    ImagePanel aip;
    Stack is;
    boolean isActive;
    boolean onDisplay;
    boolean Animation = false;
    protected MeDiViewer md;
    DisplayConfig mdc;
    double scale;
    Measurement mm;
    boolean WindowAll = false;
    boolean FlipRotateAll = false;
    PrintPreview pprev;

    public ViewerCanvas(MeDiViewer mdv) {
        this.md = mdv;
        this.setBackground(Color.black);
        this.setBorder(BorderFactory.createLineBorder(Color.white, 3));
        this.setLayout(new GridLayout(1, 1, 2, 2));
        this.setDoubleBuffered(true);
        this.mm = new Measurement();
        this.index = 0;
        this.sid = -1;
        this.mdc = new DisplayConfig();
        this.onDisplay = false;
        mode = 1;
    }

    public ViewerCanvas(MeDiViewer mdv, Stack is) {
        this.setBorder(BorderFactory.createLineBorder(Color.white, 3));
        this.setBackground(Color.white);
        this.mm = new Measurement();
        this.is = is;
        this.md = mdv;
        this.setLayout(new GridLayout(1, 1, 2, 2));
        this.setDoubleBuffered(true);
        this.onDisplay = false;
    }

    public void calibratePanel(ImagePanel ip) {
        if (ip == null) {
            ip = (ImagePanel)this.getComponent(0);
        }
        ip.getDicomImage().setPVWC(this.mdc.getPVW(), this.mdc.getPVC());
        ip.repaint();
    }

    public void calibratePanels() {
        if (this.rows * this.columns > 1) {
            int i = 0;
            while (i < this.getComponentCount()) {
                this.ip = (ImagePanel)this.getComponent(i);
                this.ip.getDicomImage().setPVWC(this.mdc.getPVW(), this.mdc.getPVC());
                ++i;
            }
        }
    }

    public void dispose() {
        this.onDisplay = false;
        this.sid = -1;
        this.index = 0;
        this.is.clear();
        this.mdc.reset();
        System.gc();
    }

    public void clearMeasurements() {
        this.mm.clear();
        this.repaint();
    }

    public void fitImages() {
        this.ip = (ImagePanel)this.getComponent(0);
        this.ip.fitImage();
        this.repaint();
    }

    public void forward() {
        int maximg = this.rows * this.columns;
        if (this.index < this.is.size() - maximg) {
            ++this.index;
            if (this.getComponentCount() > 1) {
                this.ip = (ImagePanel)this.getComponent(0);
                this.remove(0);
                int idx = this.index + maximg - 1;
                this.ip.setDicomImage((DicomImage)this.is.elementAt(idx), idx);
                if (this.WindowAll) {
                    this.calibratePanel(this.ip);
                }
                this.add(this.ip);
                this.validate();
            } else {
                this.ip = (ImagePanel)this.getComponent(0);
                this.ip.setDicomImage((DicomImage)this.is.elementAt(this.index), this.index);
                if (this.WindowAll) {
                    this.calibratePanel(this.ip);
                }
            }
            this.ip = null;
            this.setActivePanel(null);
        }
    }

    public void enableCineMode() {
        this.Animation = true;
        this.ip = (ImagePanel)this.getComponent(0);
        this.ip.setCine(true);
        this.ip = null;
        this.PreloadImages();
    }

    public void disableCineMode() {
        this.ip = (ImagePanel)this.getComponent(0);
        this.ip.setCine(false);
        this.ip = null;
        int i = 0;
        while (i < this.is.size()) {
            if (i != this.index) {
                ((DicomImage)this.is.elementAt(i)).dispose();
            }
            ++i;
        }
        this.Animation = false;
        System.gc();
    }

    public int forwardAnimation(int modus) {
        if (this.index + 1 >= this.is.size()) {
            if (modus == 1) {
                this.index = -1;
                return 0;
            }
            if (modus == 3) {
                this.rewind();
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public int rewindAnimation(int modus) {
        if (this.index - 1 < 0) {
            if (modus == 2) {
                this.index = this.is.size();
                return 0;
            }
            if (modus == 3) {
                this.forward();
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public void reloadPanels() {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.ip = (ImagePanel)this.getComponent(i);
            this.ip.setDicomImage((DicomImage)this.is.elementAt(i + this.index), i + this.index);
            if (this.WindowAll) {
                this.calibratePanels();
            }
            ++i;
        }
        this.ip = null;
        this.setActivePanel(null);
        this.repaint();
    }

    public void fastForward() {
        if (this.getComponentCount() < 4) {
            this.forward();
        } else if (this.index + 4 < this.is.size() - this.rows * this.columns - 1 && this.index + 4 != this.is.size() - this.rows * this.columns - 1) {
            this.index += 4;
            this.reloadPanels();
        } else if (this.index != this.is.size() - this.rows * this.columns) {
            this.index = this.is.size() - this.rows * this.columns;
            this.reloadPanels();
        }
    }

    public DicomImage getActiveDicomImage() {
        if (this.aip != null) {
            return (DicomImage)this.is.elementAt(this.aip.getImageIndex());
        }
        return (DicomImage)this.is.elementAt(0);
    }

    public ImagePanel getActivePanel() {
        if (this.aip != null) {
            return this.aip;
        }
        return (ImagePanel)this.getComponent(0);
    }

    public DisplayConfig getDisplayConfig() {
        return this.mdc;
    }

    public int getImageCount() {
        if (this.is == null) {
            return 0;
        }
        return this.is.size();
    }

    public Stack getImageStack() {
        return this.is;
    }

    public int getMode() {
        return mode;
    }

    public ImagePanel getPanel(int index) {
        return (ImagePanel)this.getComponent(index);
    }

    public int getStudyID() {
        return this.sid;
    }

    public int getXRay() {
        return this.xray;
    }

    public void gotoLeftRightEnd(boolean left) {
        boolean doUpdate = false;
        if (left && this.index != 0) {
            this.index = 0;
            doUpdate = true;
        }
        if (!left && this.index != this.is.size() - this.rows * this.columns) {
            this.index = this.is.size() - this.rows * this.columns;
            doUpdate = true;
        }
        if (doUpdate) {
            int i = 0;
            while (i < this.getComponentCount()) {
                this.ip = (ImagePanel)this.getComponent(i);
                this.ip.setDicomImage((DicomImage)this.is.elementAt(this.index + i), this.index + i);
                ++i;
            }
            this.repaint();
        }
        this.setActivePanel(null);
        if (this.WindowAll) {
            this.calibratePanels();
        }
    }

    public void init() {
        if (this.rows * this.columns == 0 || this.is.size() < this.rows * this.columns) {
            if (this.is.size() >= 4) {
                this.setRowCol(2, 2);
            } else if (this.is.size() == 2) {
                this.setRowCol(1, 2);
            } else {
                this.setRowCol(1, 1);
            }
        } else {
            this.setPanels();
        }
        this.ip = (ImagePanel)this.getComponent(0);
        DicomImage dcmImg = this.ip.getDicomImage();
        this.mdc.setWidthAndCenter(dcmImg.getWindowWidth(), dcmImg.getWindowCenter());
        this.mdc.centerHU2PV(dcmImg.getSlope(), dcmImg.getIntercept());
        this.mdc.widthHU2PV(dcmImg.getSlope());
        dcmImg = null;
        if (this.WindowAll) {
            this.calibratePanels();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isOnDisplay() {
        return this.onDisplay;
    }

    public void resetDisplay() {
        this.mdc.reset();
        this.ip = (ImagePanel)this.getComponent(0);
        DicomImage dcmImg = this.ip.getDicomImage();
        dcmImg.reset();
        this.mdc.setWidthAndCenter(dcmImg.getWindowWidth(), dcmImg.getWindowCenter());
        this.mdc.centerHU2PV(dcmImg.getSlope(), dcmImg.getIntercept());
        this.mdc.widthHU2PV(dcmImg.getSlope());
        dcmImg = null;
        this.ip = null;
        this.setActivePanel(null);
        if (this.WindowAll) {
            this.calibratePanels();
        }
        this.fitImages();
    }

    public void rewind() {
        if (this.index > 0) {
            --this.index;
            if (this.getComponentCount() > 1) {
                this.ip = (ImagePanel)this.getComponent(this.getComponentCount() - 1);
                this.remove(this.getComponentCount() - 1);
                this.ip.setDicomImage((DicomImage)this.is.elementAt(this.index), this.index);
                if (this.WindowAll) {
                    this.calibratePanel(this.ip);
                }
                this.add((Component)this.ip, 0);
                this.validate();
            } else {
                this.ip = (ImagePanel)this.getComponent(0);
                this.ip.setDicomImage((DicomImage)this.is.elementAt(this.index), this.index);
                if (this.WindowAll) {
                    this.calibratePanel(this.ip);
                }
            }
            this.ip = null;
            this.setActivePanel(null);
        }
    }

    public void fastRewind() {
        if (this.getComponentCount() < 4 || this.index - 4 < 0) {
            this.rewind();
        } else {
            this.index -= 4;
            this.reloadPanels();
        }
    }

    public void setActive(boolean stat) {
        this.isActive = stat;
        if (this.isActive) {
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 3));
            this.md.setActiveCanvas(this);
        } else {
            if (this.Animation) {
                this.md.doCommand(41);
            }
            this.setBorder(BorderFactory.createLineBorder(Color.white, 3));
        }
    }

    public void setActivePanel(ImagePanel aipan) {
        if (this.aip != null) {
            this.aip.setActive(false);
        }
        this.aip = aipan;
    }

    public void setImageStack(Stack nis, int sid) {
        this.is = nis;
        this.sid = sid;
        this.index = 0;
        this.mdc.reset();
        this.mm.clear();
        this.init();
    }

    public void setMode(int m) {
        mode = m;
    }

    public void setOnDisplay(boolean stat) {
        this.onDisplay = stat;
    }

    public void setPanels() {
        if (this.getComponentCount() < this.rows * this.columns) {
            if (this.is.size() >= this.index + this.rows * this.columns - 1) {
                int i = this.getComponentCount();
                while (i < this.rows * this.columns) {
                    this.add(new ImagePanel(this, (DicomImage)this.is.elementAt(this.index + i), this.mdc, this.index + i));
                    ++i;
                }
            } else {
                int i;
                int pIndex = 0;
                int sIndex = this.index;
                this.index += this.getComponentCount() - this.rows * this.columns;
                if (this.index < 0) {
                    int add = Math.abs(this.index);
                    i = 0;
                    while (i < add) {
                        this.add(new ImagePanel(this, (DicomImage)this.is.elementAt(this.index + this.rows * this.columns + i), this.mdc, this.index + this.rows * this.columns + i));
                        ++i;
                    }
                    this.index = 0;
                }
                i = this.index;
                while (i < sIndex) {
                    this.add((Component)new ImagePanel(this, (DicomImage)this.is.elementAt(i), this.mdc, i), pIndex++);
                    ++i;
                }
            }
        } else {
            int i = this.getComponentCount();
            while (i > this.rows * this.columns) {
                this.remove(i - 1);
                --i;
            }
        }
        this.validate();
    }

    public void setRowCol(int r, int c) {
        if ((this.rows != r || this.columns != c) && this.is.size() >= r * c) {
            this.rows = r;
            this.columns = c;
            this.setLayout(new GridLayout(this.rows, this.columns, 2, 2));
            if (!this.Animation) {
                this.mdc.setCenter(true);
            } else {
                this.getActivePanel().setScale(2.0);
            }
            this.setPanels();
            if (this.Animation) {
                this.mdc.centerImage(this.getActivePanel().getDicomImage().getImageWidth(), this.getActivePanel().getDicomImage().getImageHeight(), this.getActivePanel().getWidth(), this.getActivePanel().getHeight());
            }
            if (this.getComponentCount() > 0 && r > 1 && c > 1 && this.WindowAll) {
                this.calibratePanels();
            }
        }
    }

    public void SwitchWindowAll() {
        this.WindowAll = !this.WindowAll;
    }

    public void SwitchFlipRotateAll() {
        this.FlipRotateAll = !this.FlipRotateAll;
    }

    public boolean getWindowAll() {
        return this.WindowAll;
    }

    public boolean isFlipRotateAll() {
        return this.FlipRotateAll;
    }

    public void setXRay(int xr) {
        this.xray = xr;
        this.md.ml.updateXRay(String.valueOf(xr) + "");
    }

    public String toString() {
        String info = new String();
        int i = 0;
        while (i < this.getComponentCount()) {
            info = String.valueOf(info) + "\n";
            info = String.valueOf(info) + "width: " + ((ImagePanel)this.getComponent(i)).getWidth();
            info = String.valueOf(info) + " height: " + ((ImagePanel)this.getComponent(i)).getHeight();
            info = String.valueOf(info) + "\n";
            ++i;
        }
        return info;
    }

    private void PreloadImages() {
        int i = 0;
        while (i < this.is.size()) {
            ((DicomImage)this.is.elementAt(i)).loadImage();
            ++i;
        }
    }

    public Measurement getMeasurements() {
        return this.mm;
    }

    public void showPrintPreview() {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.black);
        g2.fillRect(0, 0, width, height);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.requestFocus();
        this.paint(g2);
        if (this.pprev == null) {
            this.pprev = new PrintPreview();
        }
        this.pprev.setPreviewImage(image);
        ((Component)this.pprev).setVisible(true);
        g2.dispose();
    }
}

