/*
 * Decompiled with CFR 0.152.
 */
package sub;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class FindWhereInComp {
    public int stampW;
    public int stampH;
    JComponent c;
    int numCol;
    int numRow;
    int w;
    int h;
    int maxImagePerCanvas;
    private static int lastSelection;

    public FindWhereInComp(JComponent c, int stampW, int stampH) {
        this.c = c;
        this.stampW = stampW + 10;
        this.stampH = stampH + 10;
        lastSelection = -1;
        this.update();
    }

    public void update() {
        this.w = this.c.getSize().width;
        this.h = this.c.getSize().height;
        this.numRow = this.h / (this.stampH - 10);
        this.numCol = this.w / (this.stampW - 10);
        this.maxImagePerCanvas = this.numRow * this.numCol;
    }

    public int findWhere(int x, int y, int numImages) {
        if (numImages <= 0) {
            return -1;
        }
        this.update();
        int colWhere = x / this.stampW;
        if (colWhere >= this.numCol) {
            return -1;
        }
        int rowWhere = y / this.stampH;
        if (rowWhere >= this.numRow) {
            return -1;
        }
        int where = rowWhere * this.numCol + colWhere;
        if (where > numImages - 1) {
            return -1;
        }
        lastSelection = where;
        return where;
    }

    public void clearRect(int where) {
        this.update();
        if (where == -1) {
            return;
        }
        int xRect = where % this.numCol * this.stampW;
        int yRect = where / this.numCol;
        Graphics g = this.c.getGraphics();
        g.setColor(Color.lightGray);
        g.draw3DRect(xRect, yRect *= this.stampH, this.stampW - 10, this.stampH - 10, true);
    }

    public int getLastSelection() {
        return lastSelection;
    }

    public int setLastSelection(int last) {
        lastSelection = last;
        if (lastSelection < -1) {
            lastSelection = -1;
        }
        return last;
    }
}

